package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;

/**
 * A two-way communications channel, used to communicate server-to-client or client-to-server.
 * 
 * Messages are guaranteed to be delivered in-order.
 * 
 * @author creichen
 *
 */
public interface ChannelInterface {
	/**
	 * Sends a message over the channel.
	 * 
	 * @param obj The object to send.
	 */
	public void send(Serializable obj);

	/**
	 * Receives the next message from this communications channel
	 * 
	 * @return The next message, or <tt>null</tt> if there is none yet
	 */
	public Serializable receiveNext();

	/**
	 * Tests whether the connection has been closed.
	 * 
	 * @return true iff the connection is closed.
	 */
	boolean isDisconnected();

	/**
	 * Closes communications and disconects
	 */
	void disconnect();
	
	/** sets a client / player name 
	 * @param string is a name for the client/player
	 * **/
	public void setUnique_playername(String string);

	/**
	 * getter for client/player name
	 * @return a client name as a string
	 */
	public String getUnique_playername();
}
