package UnitTests;

import org.junit.Test;

import Pacman.Player;
import Pacman.Map;
import static org.junit.Assert.*;

/**
 * Created by Daniel on 04.02.2016.
 */
public class PlayerTest {

    @Test
    public void testIs_ingame() throws Exception {
    	Player daniel = new Player("daniel");
    	daniel.set_is_ingame(true);
    	assertEquals(true, daniel.is_ingame());
    	daniel.isMoving = true;
    	daniel.alive = true;
    	daniel.setDir("left");
    	daniel.move();
    	daniel.setDir("right");
    	daniel.move();
    	daniel.setDir("up");
    	daniel.move();
    	daniel.setDir("down");
    	daniel.move();
    	Player daniel2 = new Player("daniel2");
    	daniel2.isMoving = true;
    	daniel2.alive = true;
    	daniel2.setDir("down");
    	daniel2.move();
    	daniel.getDir();
    }

    @Test
    public void testGetClientId() throws Exception {
    	Player daniel = new Player("daniel");
    	daniel.setClientId("35");
    	assertEquals("35",daniel.getClientId());
    }

    @Test
    public void testMove() throws Exception {
    	Player daniel = new Player("daniel");
    	daniel.isMoving = true;
    	daniel.alive = true;
    	daniel.setDir("left");
    	assertEquals("left", daniel.getDir());
    	daniel.move();
    	daniel.setDir("right");
    	assertEquals("right", daniel.getDir());
    	daniel.move();
    	daniel.setDir("up");
    	assertEquals("up", daniel.getDir());
    	daniel.move();
    	daniel.setDir("down");
    	assertEquals("down", daniel.getDir());
    	daniel.move();
    	Player daniel2 = new Player("daniel2");
    	daniel2.isMoving = true;
    	daniel2.alive = true;
    	daniel2.setDir("down");
    	daniel2.move();
    	daniel.getDir();
    }

    @Test
    public void testSetDir() throws Exception {
    	Player daniel = new Player("daniel");
    	daniel.setDir("left");
    	assertEquals("left", daniel.getDir());
    }

    @Test
    public void testGetScore() throws Exception {
    	Player daniel = new Player("daniel");
    	assertEquals(0, daniel.getScore());
    }

    @Test
    public void testSpawn() throws Exception {
    	Player daniel = new Player("daniel");
    	Map karte = new Map(45, 35);
    	daniel.spawn(3, 3, karte);
    }
}