package UnitTests;

import java.io.File;
import java.io.FileNotFoundException;

import org.junit.Test;

import Pacman.Map;
import Pacman.Player;
import static org.junit.Assert.*;

/**
 * Created by Daniel on 04.02.2016.
 */
public class MapTest {
	@Test
	public void testMap() {
		String s = "                                             \n" + "                                             \n"
				+ "                                             \n" + "        qwwwwwwwwwwwwwwwwwwwwwwwwwwwwe       \n"
				+ "        a  -------------------------pa       \n" + "        a qwwwwwwwwwwwwwwe qwwwwwwwe-a       \n"
				+ "        a a              a a       a-a       \n" + "      qwc ywwwwwwwwwwwwwwc a       a-a       \n"
				+ "      ap-----  ----- ----- a       a-a       \n" + "      a-qwwwwe qwwwe qwwwe a       a-a       \n"
				+ "      a-a    a a   a a   a ywwwwwwwc-a       \n" + "      a-a    a a   a a   a  ---------a       \n"
				+ "      a-ywwwwc ywwwc ywwwc qwwwwwwwe-a       \n" + "      a  -----------p----  a       a-a       \n"
				+ "      a-qwe qwwwwwwwwwwwwe ywwwe   a-a       \n" + "      a-a a a            a ---pa   a-a       \n"
				+ "      a-a a a            a qwe-a   a-a       \n" + "      a-ywc ywwwwwwwwwwwwc a a-a   a-a       \n"
				+ "      a           b        a a-a   a-a       \n" + "      a-qwe qwwwwe qwwwwwe a a-a   a-a       \n"
				+ "      a-a a-aqwwwc ywwwwea-ywc-ywwwc-a       \n" + "      a-a a-aa          aa-----------a       \n"
				+ "      a-a a-aa1qe2qe3qe4aa-qwwwwe qwwc       \n" + "      a-a a-aywcywcywcywca-a qwwc ywwwwwe    \n"
				+ "      a-ywc-ywwwwwwwwwwwwc-a a          a    \n" + "      ap-------------------a a5qe6qe7qe8a    \n"
				+ "      ywwwwwwwwwwwwe qwwwwwc ywcywcywcywc    \n" + "                   a a                       \n"
				+ "          qwwwwwwwwc a                       \n" + "          ap-------- a                       \n"
				+ "          ywwwwwwwwwwc                       \n" + "                                             \n";
		Map karte = new Map(45, 35);
		karte.loadString(s);
		Player daniel = new Player("daniel");
		Player dee = new Player("dee");
		Player mat = new Player("mat");
		Player lisa = new Player("lisa");
		daniel.spawn(karte.getP1x(), karte.getP1y(), karte);
		dee.spawn(karte.getP2x(), karte.getP2y(), karte);
		mat.spawn(karte.getP3x(), karte.getP3y(), karte);
		lisa.spawn(karte.getP4x(),  karte.getP4y(), karte);
		karte.chaosDisable();
		karte.chaosEnable();
		assertEquals(true, karte.equals(karte));
		assertEquals(14, karte.getBlinkyX());
		assertEquals(22, karte.getBlinkyY());
		assertEquals(18, karte.getBonusX());
		assertEquals(18, karte.getBonusY());
		karte.getCel(2, 14);
		karte.getClass();
		assertEquals(23, karte.getClydeX());
		assertEquals(22, karte.getClydeY());
		assertEquals(35, karte.getHeight());
		assertEquals(20, karte.getInkyX());
		assertEquals(22, karte.getInkyY());
		karte.getMap();
		assertEquals(148, karte.getPills());
		assertEquals(17, karte.getPinkyX());
		assertEquals(22, karte.getPinkyY());
		karte.getTile();
		assertEquals(45, karte.getWidth());
		karte.hashCode();
		karte.lost();
		karte.setPills(2);
		assertEquals(2, karte.getPills());
		karte.show();
		karte.toString();
		karte.won();
		Map.serialize(karte.getTile(), 35, 27);
		karte.deserialize(s, 45, 35);
		try {
			karte.loadLevel(new File(System.getProperty("user.dir")+ "\\src\\res\\level1.txt"));
		} catch (FileNotFoundException e) {
		}
	}
}