package UnitTests;

import org.junit.Test;

import Pacman.Enemy;
import Pacman.Map;
import static org.junit.Assert.*;

/**
 * Created by Daniel on 04.02.2016.
 */
public class EnemyTest {
public String s ="                                             \n" + "                                             \n"
		+ "                                             \n" + "        qwwwwwwwwwwwwwwwwwwwwwwwwwwwwe       \n"
		+ "        a  -------------------------pa       \n" + "        a qwwwwwwwwwwwwwwe qwwwwwwwe-a       \n"
		+ "        a a              a a       a-a       \n" + "      qwc ywwwwwwwwwwwwwwc a       a-a       \n"
		+ "      ap-----  ----- ----- a       a-a       \n" + "      a-qwwwwe qwwwe qwwwe a       a-a       \n"
		+ "      a-a    a a   a a   a ywwwwwwwc-a       \n" + "      a-a    a a   a a   a  ---------a       \n"
		+ "      a-ywwwwc ywwwc ywwwc qwwwwwwwe-a       \n" + "      a  -----------p----  a       a-a       \n"
		+ "      a-qwe qwwwwwwwwwwwwe ywwwe   a-a       \n" + "      a-a a a            a ---pa   a-a       \n"
		+ "      a-a a a            a qwe-a   a-a       \n" + "      a-ywc ywwwwwwwwwwwwc a a-a   a-a       \n"
		+ "      a           b        a a-a   a-a       \n" + "      a-qwe qwwwwe qwwwwwe a a-a   a-a       \n"
		+ "      a-a a-aqwwwc ywwwwea-ywc-ywwwc-a       \n" + "      a-a a-aa          aa-----------a       \n"
		+ "      a-a a-aa1qe2qe3qe4aa-qwwwwe qwwc       \n" + "      a-a a-aywcywcywcywca-a qwwc ywwwwwe    \n"
		+ "      a-ywc-ywwwwwwwwwwwwc-a a          a    \n" + "      ap-------------------a a5qe6qe7qe8a    \n"
		+ "      ywwwwwwwwwwwwe qwwwwwc ywcywcywcywc    \n" + "                   a a                       \n"
		+ "          qwwwwwwwwc a                       \n" + "          ap-------- a                       \n"
		+ "          ywwwwwwwwwwc                       \n" + "                                             \n";
    @Test
    public void testMove() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	blinky.setDir("left");
		Map karte = new Map(45, 35);
		karte.loadString(s);
		blinky.spawn(karte.getBlinkyX(), karte.getBlinkyY(), karte);
		karte.chaosEnable();
		assertTrue(karte.chaos);
    	blinky.move();
    }

    @Test
    public void testMove1() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	Map karte = new Map(45, 35);
    	karte.loadString(s);
    	blinky.spawn(karte.getBlinkyX(), karte.getBlinkyY(), karte);
    	karte.setPills(2);
    	blinky.move("left");
    	blinky.move("right");
    	blinky.move("up");
    	blinky.move("down");
    }

    @Test
    public void testSetIntelligence() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	blinky.setIntelligence("random");
    }

    @Test
    public void testMove2() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	blinky.move(1, 0);
    }

    @Test
    public void testSetDir() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	blinky.setDir("left");
    }

    @Test
    public void testGetDir() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	blinky.setDir("left");
    	assertEquals("left", blinky.getDir());
    }

    @Test
    public void testDie() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	blinky.die();
    }

    @Test
    public void testSpawn() throws Exception {
    	Enemy blinky = new Enemy("blinky", "looking");
    	Map karte = new Map(35,27);
    	blinky.spawn(3, 4, karte);
    }
}