package Pacman;

/**
 * the Player class represents a player on the map, that can move around
 */
public class Player implements Tile {
	/** current looking-direction **/
	private String dir = "right";
	/** player name, not to be confused with clientId **/
	public String name;
	/** the name of the human controlling the player**/
	public String playername;
	/** current playerscore **/
	public int score = 0;
	/** x value of the current position **/
	public short x;
	/** y value of the current position **/
	public short y;
	/** does the player move ? **/
	public boolean isMoving = false;
	/** is the player alive or dead **/
	public boolean alive;
	/**
	 * the map to navigate on; will be passed over from the server from tick to
	 * tick
	 **/
	private Map map;
	/** is the player ready to start the game ? **/
	public boolean ready2play = false;
	/**
	 * unique player-id given by the server, not to be confused with the player
	 * name
	 **/
	private String clientId = "";
	/** is true if the player is element of the current game **/
	private boolean is_ingame = false;

	/**
	 * returns true, if the player is in the game
	 * 
	 * @return the is_ingame
	 */
	public boolean is_ingame() {
		return is_ingame;
	}

	/**
	 * @param is_ingame
	 *            the is_ingame to set
	 */
	public void set_is_ingame(boolean is_ingame) {
		this.is_ingame = is_ingame;
	}

	/**
	 * @return the clientId
	 */
	public String getClientId() {
		return clientId;
	}

	/**
	 * @param clientId
	 *            the clientId to set
	 */
	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	/**
	 * constructor
	 * 
	 * @param name
	 *            sets the <b>player's name</b>
	 * @see should be element of {"p1","p2","p3","p4"}
	 */
	public Player(String name) {
		this.name = name;
	}

	/** moves the player by 1 into the current direction set **/
	public void move() {
		if (dir.equals("up") && isMoving && alive)
			move(0, -1);
		else if (dir.equals("down") && isMoving && alive)
			move(0, 1);
		else if (dir.equals("left") && isMoving && alive)
			move(-1, 0);
		else if (dir.equals("right") && isMoving && alive)
			move(1, 0);
	}

	/**
	 * called by move() to compute the position (and their effects) of our
	 * players
	 * 
	 * @param x
	 *            is the x direction
	 * @param y
	 *            is the y direction
	 */
	private void move(int x, int y) {
		try {
			/** check for / avoid wall collisions **/
			if (!(map.getCel(this.x + x, this.y + y) instanceof Wall
					|| map.getCel(this.x + x, this.y + y) instanceof Player)) {
				if (!(map.getCel(this.x + x, this.y + y) instanceof Enemy)) {
					/** increase score on pill taking **/
					if (map.getCel(this.x + x, this.y + y) instanceof Pill) {
						if (((Pill) map.getCel(this.x + x, this.y + y)).power) {
							map.chaosEnable();
						} else {
							this.score++;
							map.setPills(map.getPills() - 1);
						}
					}
					/** handle bonus **/
					if (map.getCel(this.x + x, this.y + y) instanceof Bonus) {
						if (((Bonus) (map.getCel(map.getBonusX(), map.getBonusY()))).isVisible())
							this.score += 15;
						map.randomBonusNr = (int) (Math.random() * 4);
						map.bonusCooldown = (map.bonusCooldown == 0) ? 60 : map.bonusCooldown;
					}

					map.setCel(this.x + x, this.y + y, this);
					map.setCel(this.x, this.y, new Air());
					this.x += x;
					this.y += y;
				}
				/** handle enemy contact **/
				else if (map.getCel(this.x + x, this.y + y) instanceof Enemy) {
					if (map.chaos) {
						((Enemy) map.getCel(this.x + x, this.y + y)).die();
						map.setCel(this.x + x, this.y + y, this);
						map.setCel(this.x, this.y, new Air());
						this.x += x;
						this.y += y;
						this.score += 10;
					}
				}

			}
			/** collisions **/
			else if (map.getCel(this.x + x, this.y + y) instanceof Wall)
				isMoving = false;
		} catch (Exception e) {
			isMoving = false;
		}
		this.setDir(dir);
	}

	/** sets the direction of a Player **/
	public void setDir(String dir) {
		this.dir = dir;
	}

	/** gets the direction of a Player **/
	public String getDir() {
		return dir;
	}

	/** gets the score of a Player **/
	public int getScore() {
		return score;
	}

	/**
	 * spawns the Player at a specific location on our map
	 * 
	 * @param x
	 *            is the x position
	 * @param x
	 *            is the y position
	 * @map is the map, where we place our Player
	 **/
	public void spawn(int x, int y, Map map) {
		this.map = map;
		this.alive = true;
		this.x = (short) x;
		this.y = (short) y;
		/** increase the players on our map (redundant player tracking) **/
		map.players++;
		/** put out player here: **/
		map.setCel(x, y, this);
	}

}
