package Pacman;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;

import de.uni_frankfurt.prgpr.core.ChannelInterface;
import de.uni_frankfurt.prgpr.core.NewServerInterface;
import de.uni_frankfurt.prgpr.core.ServerServiceInterface;

/**
 * Trivial server implementation to illustrate ServerInterface.
 * 
 * @author creichen
 * 
 */

public class PacmanServer implements NewServerInterface {
	/** variable to set server output to additional debug information **/
	private boolean debugmode = true;

	/** counts the players that are ready to play **/
	private int counter = 0;

	/** a list of (probably) connected clients **/
	private ArrayList<ChannelInterface> clients = new ArrayList<>();

	/** did the game start? **/
	private boolean started = false;

	/** a list of Players **/
	private ArrayList<Player> pxList = new ArrayList<>();

	/** log interface to use for output messages on server **/
	public ServerServiceInterface logger;

	/** amount of connected clients **/
	public int total_clients = 0;

	/** trick to display more than 1 line on our server debug output **/
	public String debuglog = "";

	/** map for Pacman; will be sent to all clients reguarly **/
	private Map map = new Map(45, 35);

	/* Enemy instances */
	private Enemy blinky = new Enemy("blinky", "random"); // rot
	private Enemy pinky = new Enemy("pinky", "random"); // pink
	private Enemy inky = new Enemy("inky", "random"); // inky
	private Enemy clyde = new Enemy("clyde", "random"); // orange

	/* Player instances */
	private Player p1 = new Player("p1");
	private Player p2 = new Player("p2");
	private Player p3 = new Player("p3");
	private Player p4 = new Player("p4");

	/** server speed / tick rate **/
	private int currentTick = 0;

	/** the amount of ticks the game has proceeded **/
	private int gameTick = 0;

	/**
	 * counts the number of players
	 * 
	 * @return players amount
	 */
	public int countPlayers() {
		int i = 0;
		for (Player p : pxList) {
			if (!p.getClientId().equals("")) {
				i++;
			}
		}
		return i;
	}

	/** initializes the map and the ghosts **/
	public void startGame() {
		this.debuglog += "------------------------------------- [startGame():] -------------------------------------\n";
		String s = "                                             " + '\n'
				+ "                                             " + '\n'
				+ "                                             " + '\n'
				+ "        qwwwwwwwwwwwwwwwwwwwwwwwwwwwwe       " + '\n'
				+ "        a  -------------------------pa       " + '\n'
				+ "        a qwwwwwwwwwwwwwwe qwwwwwwwe-a       " + '\n'
				+ "        a a              a a       a-a       " + '\n'
				+ "      qwc ywwwwwwwwwwwwwwc a       a-a       " + '\n'
				+ "      ap-----  ----- ----- a       a-a       " + '\n'
				+ "      a-qwwwwe qwwwe qwwwe a       a-a       " + '\n'
				+ "      a-a    a a   a a   a ywwwwwwwc-a       " + '\n'
				+ "      a-a    a a   a a   a  ---------a       " + '\n'
				+ "      a-ywwwwc ywwwc ywwwc qwwwwwwwe-a       " + '\n'
				+ "      a  -----------p----  a       a-a       " + '\n'
				+ "      a-qwe qwwwwwwwwwwwwe ywwwe   a-a       " + '\n'
				+ "      a-a a a            a ---pa   a-a       " + '\n'
				+ "      a-a a a            a qwe-a   a-a       " + '\n'
				+ "      a-ywc ywwwwwwwwwwwwc a a-a   a-a       " + '\n'
				+ "      a           b        a a-a   a-a       " + '\n'
				+ "      a-qwe qwwwwe qwwwwwe a a-a   a-a       " + '\n'
				+ "      a-a a-aqwwwc ywwwwea-ywc-ywwwc-a       " + '\n'
				+ "      a-a a-aa          aa-----------a       " + '\n'
				+ "      a-a a-aa1qe2qe3qe4aa-qwwwwe qwwc       " + '\n'
				+ "      a-a a-aywcywcywcywca-a qwwc ywwwwwe    " + '\n'
				+ "      a-ywc-ywwwwwwwwwwwwc-a a          a    " + '\n'
				+ "      ap-------------------a a5qe6qe7qe8a    " + '\n'
				+ "      ywwwwwwwwwwwwe qwwwwwc ywcywcywcywc    " + '\n'
				+ "                   a a                       " + '\n'
				+ "          qwwwwwwwwc a                       " + '\n'
				+ "          ap-------- a                       " + '\n'
				+ "          ywwwwwwwwwwc                       " + '\n'
				+ "                                             " + '\n';
		/**
		 * MAP LOADING:
		 */
		map.setPills(0);
		map.players = 0;
		map.chaosLasting = 1;
		map.bonusCooldown = 100;
		map.loadString(s);
		
		/** let the clients play 'In Flames - Trigger' again! **/
		broadcastAll("res");
		/** spawn blinky on the map **/
		blinky.spawn(map.getBlinkyX(), map.getBlinkyY(), map);
		/** set enemy ai **/
		blinky.setIntelligence("looking");
		/** spawn pinky on the map **/
		pinky.spawn(map.getPinkyX(), map.getPinkyY(), map);
		/** spawn inky on the map **/
		inky.spawn(map.getInkyX(), map.getInkyY(), map);
		/** spawn clyde on the map **/
		clyde.spawn(map.getClydeX(), map.getClydeY(), map);
		map.score = 0;
		for (Player p : pxList) {
			i: switch (p.name) {
			case "p1":
				if (!p.getClientId().equals("")) {
					p.spawn(map.getP1x(), map.getP1y(), map);
					p.score = 0;
				}
				break i;
			case "p2":
				if (!p.getClientId().equals("")) {
					p.spawn(map.getP2x(), map.getP2y(), map);
					p.score = 0;
				}
				break i;
			case "p3":
				if (!p.getClientId().equals("")) {
					p.spawn(map.getP3x(), map.getP3y(), map);
					p.score = 0;
				}
				break i;
			case "p4":
				if (!p.getClientId().equals("")) {
					p.spawn(map.getP4x(), map.getP4y(), map);
					p.score = 0;
				}
				break i;
			}
		}
	}

	/**
	 * updates the current connected clients and removes disconnected clients
	 * from list sends a msg to all connected clients, if another client is
	 * disconnected
	 */
	public void removeDisconnectedClients() {
		try {
			/** work on an empty ArrayList for savety **/
			ArrayList<ChannelInterface> updated_clients = new ArrayList<>();
			for (ChannelInterface c : getClients()) {
				if (c.isDisconnected()) {
					/** remove PlayerData from playerlist: **/
					for (Player p : pxList) {
						if (((Integer) c.hashCode()).toString().equals(p.getClientId())) {
							/** reset playerdata: **/
							String namehelp = p.name;
							p = new Player(namehelp);

							this.debuglog += p.name + "-> data reset initialized\n";
							this.debuglog += " Player removed ";
						}
					}
					/** update client number **/
					this.total_clients--;
					/** update players number on map instance **/
					map.players = (short) total_clients;

				} else {
					/** add client to our temporary client list **/
					updated_clients.add(c);
				}
			}
			/** overwrite our client list with computed data **/
			this.clients = updated_clients;
		} catch (Exception e) {
			debugOut("[removeDisconnectedClients:] " + e.toString());
		}
	}

	/**
	 * Called when the server is first initialised
	 * 
	 * @param serviceInterface
	 *            is the logging interface A logging system that can be used for
	 *            output
	 */
	public void init(ServerServiceInterface serviceInterface) {
		/** logger will be used to see what is going on @ the serverside **/
		this.logger = serviceInterface;
		/** add all players to our list of players **/
		pxList.add(p1);
		pxList.add(p2);
		pxList.add(p3);
		pxList.add(p4);
		/** what do you think it does ? **/
		startGame();

	}

	/**
	 * show the current players list, a debug method
	 * 
	 * @return list of players as a String
	 */
	public String currentPlayers() {
		String x = "";
		for (Player p : pxList) {
			x += "Player: " + p.name + " | Id: " + p.getClientId() + " | alive:" + p.alive + " | pos: " + p.x + ","
					+ p.y + " | looking: " + p.getDir() + "\n";
		}
		return x;
	}

	/**
	 * shows map information of current map as string
	 * 
	 * @return a debug string
	 */
	public String debugMap() {
		String x = "";
		x += "Chaos Mode: " + map.chaos + " | Pills: " + map.pills + " | Players: " + map.players + " | Lost: "
				+ map.lost() + " | Won: " + map.won() + " | P1x " + map.getP1x() + "," + map.getP1y() + " | P2x "
				+ map.getP2x() + "," + map.getP2y() + " | P3x " + map.getP3x() + "," + map.getP3y() + " | P4x "
				+ map.getP4x() + "," + map.getP4y() + "\n";
		return x;
	}

	/**
	 * main game logic to compute the player movements and changes on the map
	 **/
	public void gameLogic() {
		/** make sure, the map is playable **/
		if (!map.won() && !map.lost()) {
			/**
			 * if there are no players left, let enemies stay at their spawn:
			 **/
			if (countPlayers() < 1) {
				blinky.spawn(map.getBlinkyX(), map.getBlinkyY(), map);
				pinky.spawn(map.getPinkyX(), map.getPinkyY(), map);
				inky.spawn(map.getInkyX(), map.getInkyY(), map);
				clyde.spawn(map.getClydeX(), map.getClydeY(), map);
			}
			/** start game if player wants to play singleplayer **/
			else if (countPlayers() >= 1) {
				gameTick++;
				/** compute the players' and enemies' positions: **/
				p1.move();
				p2.move();
				p3.move();
				p4.move();
				if (blinky.alive)
					blinky.move();
				else {
					blinky.deathLasting--;
					if (blinky.deathLasting == 0)
						blinky.spawn(map.getBlinkyX(), map.getBlinkyY(), map);
				}
				/** let enemies move a few ms later **/
				if (gameTick > 15) {
					if (pinky.alive)
						pinky.move();
					else {
						pinky.deathLasting--;
						if (pinky.deathLasting == 0)
							pinky.spawn(map.getPinkyX(), map.getPinkyY(), map);
					}
				}
				if (gameTick > 30) {
					if (inky.alive)
						inky.move();
					else {
						inky.deathLasting--;
						if (inky.deathLasting == 0)
							inky.spawn(map.getInkyX(), map.getInkyY(), map);
					}
				}
				if (gameTick > 45) {
					if (clyde.alive)
						clyde.move();
					else {
						clyde.deathLasting--;
						if (clyde.deathLasting == 0)
							clyde.spawn(map.getClydeX(), map.getClydeY(), map);
					}
				}
				/** chaos-mode enables player to eat the enemy **/
				if (map.chaos)
					map.chaosLasting--;
				if (map.chaosLasting == 0)
					map.chaosDisable();
				if (map.bonusCooldown > 0)
					map.bonusCooldown--;
				else {
					map.setCel(map.getBonusX(), map.getBonusY(), new Air());
				}
				if (map.getCel(map.getBonusX(), map.getBonusY()) instanceof Air) {
					map.setCel(map.getBonusX(), map.getBonusY(), new Bonus(map.randomBonusNr, map.bonusCooldown == 0));
				}
				/** send all information to all connected clients / players **/
				broadcastAll("d1:" + blinky.getDir());
				broadcastAll("d2:" + pinky.getDir());
				broadcastAll("d3:" + inky.getDir());
				broadcastAll("d4:" + clyde.getDir());
				broadcastAll("p1:" + p1.getDir());
				broadcastAll("p2:" + p2.getDir());
				broadcastAll("p3:" + p3.getDir());
				broadcastAll("p4:" + p4.getDir());
				/** bonus **/
				if (map.getCel(map.getBonusX(), map.getBonusY()) instanceof Bonus) {
					broadcastAll("bon" + map.randomBonusNr + map.bonusCooldown);
				} // bonuscooldown
				broadcastAll("cha" + ((Boolean) map.chaos).toString());
				broadcastAll("sco" + ((Integer) p1.score + p2.score + p3.score + p4.score));
				broadcastAll("map" + Map.serialize(map.getMap(), 45, 35));
				/** update the highscores **/
				for (int i = 0; i < total_clients; i++) {
					thisSwitch: switch (i) {
					case 0:
						getClients().get(i).send("psc" + p1.score);
						break thisSwitch;
					case 1:
						getClients().get(i).send("psc" + p2.score);
						break thisSwitch;
					case 2:
						getClients().get(i).send("psc" + p3.score);
						break thisSwitch;
					case 3:
						getClients().get(i).send("psc" + p4.score);
						break thisSwitch;
					}
				}

			}
		} else if (map.lost()) {
			/** restart game by resetting some parameters: **/
			/** play the death sound **/
			broadcastAll("end");
			started = false;
		} else if (map.won()) {
			broadcastAll("won");
			started = false;
		}

	}

	/**
	 * Called regularly, ideally once every `tick' (25 ms)
	 * 
	 * This method may not be called for every tick. It's possible to determine
	 * skipped ticks by looking at the `ticks' parameter.
	 * 
	 * @param tickCount
	 *            The number of ticks elapsed since the server started
	 */
	@Override
	public void update(int tickCount) {
		/** make sure our debug always knows the current tick **/
		currentTick = tickCount;
		/** update our list of connected clients / players: **/
		removeDisconnectedClients();
		/** initial server-side-log **/
		logger.println("(" + tickCount + ") |GameServer:| [" + this.total_clients + "] connected clients: "
				+ getClients() + "\n" + "[Status: ]\n" + currentPlayers() + "[MapInfo:]\n" + debugMap()
				+ "\n[CURRENT MAP:]\n" + Map.serialize(map.getMap(), map.getWidth(), map.getHeight()) + "\n"
				+ "\tUpdate PRIORITY:" + Thread.currentThread().getPriority() + "[DEBUG LOG:]\n " + this.debuglog);
		/**
		 * "slow" the servers computation power, to get a better sync with the
		 * client
		 **/
		try {
			Thread.currentThread();
			Thread.sleep(155);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		/** check for players, that want to start playing **/
		counter = 0;
		for (Player s : pxList) {
			counter += (s.ready2play) ? 1 : 0;
		}
		/** wait until all players are ready to play **/
		if (counter == total_clients && total_clients > 0) {
			started = true;
			gameLogic();
		} else {
			started = false;
			for (ChannelInterface c : clients) {
				int i = 1;
				for (Player p : pxList) {
					if (!(p.playername == null)) {
						if (!p.ready2play) {
							c.send("rf" + i + p.playername);
						} else {
							c.send("rt" + i + p.playername);
						}
						debugOut("sent info for player " + i);
						i++;
					}

				}
			}
		}
	}

	/**
	 * Called when the server observes a client connection
	 * 
	 * @param client
	 *            The client that wants to connect
	 * @return true if the connection was accepted
	 */
	@Override
	public boolean connectClient(ChannelInterface client) {
		if (total_clients > 3) {
			this.debuglog += "max players reached, refused new client with id " + client.hashCode() + "\n";
			return false;
		} // starts with 0
		if (!client.isDisconnected()) {
			// debugging output:
			this.debuglog += "[connectClient:] Client " + client.hashCode() + " connected\n";

			try {
				/** give the player/ client a name **/
				String clientId = ((Integer) (client.hashCode())).toString();
				debugOut("[connectClient:]\nPlayer " + total_clients + " has ID " + clientId);
				// create new player with unique id and save data in a list of

				/** player[total_clients] gets an id from the server: **/
				pxList.get(total_clients).setClientId(clientId);

				this.debuglog += "Player " + pxList.get(total_clients).name + " got id "
						+ pxList.get(total_clients).getClientId();

				/** Player is in-game now: **/
				pxList.get(total_clients).set_is_ingame(true);

				/** decide which multiplayer mode should be chosen **/
				if (total_clients == 0) {
					p1.spawn(map.getP1x(), map.getP1y(), map);
					p1.alive = true;
					this.debuglog += "\n***Starting Game in SinglePlayer Mode***-\n";
					p2.alive = p3.alive = p4.alive = false;

				} else if (total_clients == 1) {
					p2.spawn(map.getP2x(), map.getP2y(), map);
					p2.alive = true;
					this.debuglog += "\n***Starting Game in 2-Player Mode***-\n";
					p3.alive = p4.alive = false;
				} else if (total_clients == 2) {
					p3.spawn(map.getP3x(), map.getP3y(), map);
					p3.alive = true;
					this.debuglog += "\n***Starting Game in 3-Player Mode***-\n";
					p4.alive = false;
				} else if (total_clients == 3) {
					p4.spawn(map.getP4x(), map.getP4y(), map);
					p4.alive = true;
					this.debuglog += "\n***Starting Game in 4-Player Mode***-\n";
				} else {
					debugOut("Server is full");
				}
				/* end test */
			} catch (Exception e) {
				debugOut("[connectClient:]\nserver exception: " + e);

			}

			/** add new client to our client list **/
			setClients(client);
			/** increase the number of connected clients by one **/
			this.total_clients++;
			// debugging output:
			this.debuglog += "[connectClient:]Client added..." + " (total clients now: " + getClients().size() + ")\n";

			return true;
		} else {
			this.debuglog += "[connectClient:]Client denied" + "\n";
			return false;
		}

	}

	/**
	 * Called when the server receives a message
	 * 
	 * @param client
	 *            The client who sent the message
	 * @param message
	 *            The object that is the message
	 */
	@Override
	public void receive(ChannelInterface client, Serializable message) {
		/** sends the received msg to all clients **/

		// this.debuglog += ">>>>> RECEIVE-Update-PRIORITY:" +
		// Thread.currentThread().getPriority() + "\n";

		/**
		 * use the memory id of the client object as unique id for the
		 * player/client
		 **/
		String clientId = ((Integer) client.hashCode()).toString();

		/** add all to our debuglog **/
		// this.debuglog += "-------------------------------------- [RECEIVE:]
		// --------------------------------------\n";
		// this.debuglog += "Player with ID " + client.hashCode() + " sends
		// message: " + message.toString() + "\n";

		/** parse the received client messages for commando inputs **/
		String msg = (String) message;
		for (Player p : pxList) {
			/** make sure to handle the correct client/player **/
			if (p.getClientId().equals(clientId)) {
				/*
				 * this.debuglog += "p.getClientId() [" + p.getClientId() +
				 * "].equals(" + clientId + ") = "
				 * + p.getClientId().equals(clientId) + "\n";
				 */
				/** parse for moving commands **/
				if (msg.equals("up") || msg.equals("down") || msg.equals("left") || msg.equals("right")) {
					p.setDir(msg);
					p.isMoving = true;
					/** parse for "ready-to-play" command **/
				} else if (msg.equals("ready") && !started) {
					p.ready2play = true;
				} else if (msg.equals("unready") && !started) {
					p.ready2play = false;
				} else if (msg.startsWith("name")) {
					msg = msg.substring(4);
					p.playername = msg;
				} else if (msg.equals("/r")) {
					gameTick = 0;
					map.bonusCooldown = 100;
					map.chaosLasting = 0;
					startGame();
				} else {
					// debug
					this.debuglog += ("command unknown: " + msg + "\n");
				}
				/*
				 * this.debuglog += "[" + currentTick + "]" + "Player " + p.name
				 * + "[Id: " + p.getClientId()
				 * + "] @ position: " + p.x + "/" + p.y;
				 * this.debuglog += "-> [isMoving: " + p.isMoving + "| dir: " +
				 * p.getDir() + "| alive: " + p.alive
				 * + "] \n";
				 */
			}
		}
	}

	/**
	 * sends a message to all connected clients
	 * 
	 * @param message
	 *            is the message, that shall be broadcasted to all connected
	 *            clients
	 */
	public void broadcastAll(Serializable message) {
		for (ChannelInterface client : getClients()) {
			// debug:
			debugOut("[broadcastAll:] sending " + (String) message + " to all");
			/** send a message to all connected clients **/
			client.send((String) message);
		}
	}

	/**
	 * getter for list of all clients return ArrayList<ChannelInterface>
	 * 
	 * @return a list of (connected) client-objects
	 **/
	public ArrayList<ChannelInterface> getClients() {
		if (clients != null) {
			return clients;
		} else
			throw new RuntimeException("no clients connected");
	}

	/**
	 * setter: adds a client to our clientlist
	 * 
	 * @param client
	 *            is a ChannelInterface
	 */
	public void setClients(ChannelInterface client) {
		this.clients.add(client);
	}

	/** debug logger - prints to server log **/
	public void debugOut(String s) {
		if (debugmode) {
			this.debuglog += "[" + currentTick + "]" + s + "\n";
		}

	}
}