package Pacman;

import de.uni_frankfurt.prgpr.core.ChannelInterface;
import de.uni_frankfurt.prgpr.core.ClientInterface;
import de.uni_frankfurt.prgpr.phase3.gui.UIPanel;

/**
 * 
 * Clientinterface, that may send Messages to a serverIO channel
 */
public class PacmanClient implements ClientInterface {
	/** map from server **/
	public Map map = new Map(45, 35);

	/**
	 * takes a graphical UIPanel and communication channel initializes the gui
	 * for each client
	 */
	public void init(UIPanel panel, ChannelInterface serverchan) {

		/** sets up the panel **/
		panel.setup();

		/** draw everything on our canvas **/
		MyDrawer drawer = new MyDrawer(map.getWidth(), map.getHeight(), map);

		/**
		 * EventHandler (keyboard) for PacMan's movement
		 */
		MyUIEventDelegate em = new MyUIEventDelegate(panel, serverchan, map, drawer);
		/** set focus to canvas at last to keep the textinput field on focus **/
		panel.setCanvasFocus();
		/** connect the event handler with our panel **/
		panel.setEventDelegate(em);
		/** put the drawer on the UIPanel **/
		panel.setDrawer(drawer);
		/** show the gui **/
		panel.show();

	}

}
