package Pacman;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

import de.uni_frankfurt.prgpr.core.*;
import de.uni_frankfurt.prgpr.phase3.gui.UIEventDelegate;
import de.uni_frankfurt.prgpr.phase3.gui.UIPanel;

public class MyUIEventDelegate implements UIEventDelegate {
	/** the clients UIPanel **/
	public UIPanel p;
	/** the communication interface between server and client **/
	public ChannelInterface serverchan;
	/** the local Map, that the server will refresh from tick to tick **/
	private Map map;
	/** AudioHandler to play some background-waveloop **/
	private AudioHandler audioHandler = new AudioHandler();
	/** the drawer to use for the panel **/
	private MyDrawer mDrawer;
	/** remebers if the human is ready to play or not **/
	private boolean ready = false;
	/** true if the game is lost, used to play the death sound **/
	private boolean lost = false;
	/** true if the level was won by the players. makes ACDC play ^_^**/
	private boolean won = false;

	/**
	 * Constructor takes an UIPanel and a communication interface
	 * (ChannelInterface)
	 * 
	 * @param panel
	 *            is our UIPanel
	 * @param serverChannel
	 *            is a communication interface (ChannelInterface)
	 * @param m
	 *            is the local Map, that the server will refresh from tick to
	 *            tick
	 * @param mDrawer
	 *            is the drawer to use for the panel
	 */
	public MyUIEventDelegate(UIPanel panel, ChannelInterface serverChannel, Map m, MyDrawer mDrawer) {
		this.p = panel;
		this.mDrawer = mDrawer;
		this.map = m;
		this.serverchan = serverChannel;
		serverchan.send("name" + System.getProperty("user.name"));
	}

	/**
	 * checks the communication channel for changes every tickCount ticks in ms
	 * 
	 * @param tickCount
	 *            refresh ticks in ms
	 */
	@Override
	public void observeTick(int tickCount) {
		/** get the waveloop from our users' system dir **/
		if (mDrawer.started && lost)
			audioHandler.setSong(System.getProperty("user.dir") + "\\src\\res\\lost.wav", false);
		else if (mDrawer.started && won)
			audioHandler.setSong(System.getProperty("user.dir") + "\\src\\res\\won.wav", true);
		else {
			audioHandler.setSong(System.getProperty("user.dir") + "\\src\\res\\ingame.wav", true);
		}
		/** receive new messages broadcasted from the server: **/
		Serializable s = null;
		String msg = null;
		s = serverchan.receiveNext();
		/** avoid messages that contain NULL: **/
		if (s != null) {
			msg = (String) s;
			/**
			 * parse specific server commandos: if a msg starts with "map", it
			 * will take it as a map object to deserialize and load into our
			 * local map:
			 */
			if (msg.startsWith("map")) {
				mDrawer.started = true;
				msg = msg.substring(3);
				map.loadString(msg);

			} /**
				 * parse specific server commandos: d1, d2, d3 and d4 are the
				 * enemies' directions that we receive from our server:
				 */
			else if (msg.startsWith("d1:")) {
				msg = msg.substring(3);
				map.bdir = msg;

			}
			/**
			 * parse specific server commandos: d1, d2, d3 and d4 are the
			 * enemies' directions that we receive from our server:
			 */
			else if (msg.startsWith("d2:")) {
				msg = msg.substring(3);
				map.pdir = msg;
			}
			/**
			 * parse specific server commandos: d1, d2, d3 and d4 are the
			 * enemies' directions that we receive from our server:
			 */
			else if (msg.startsWith("d3:")) {
				msg = msg.substring(3);
				map.idir = msg;
			}
			/**
			 * parse specific server commandos: d1, d2, d3 and d4 are the
			 * enemies' directions that we receive from our server:
			 */
			else if (msg.startsWith("d4:")) {
				msg = msg.substring(3);
				map.cdir = msg;
			}
			/**
			 * parse specific server commandos: p1, p2, p3 and p4 are the
			 * players' directions that we receive from our server:
			 */
			else if (msg.startsWith("p1:")) {
				msg = msg.substring(3);
				map.p1dir = msg;
			}
			/**
			 * parse specific server commandos: p1, p2, p3 and p4 are the
			 * players' directions that we receive from our server:
			 */
			else if (msg.startsWith("p2:")) {
				msg = msg.substring(3);
				map.p2dir = msg;
			}
			/**
			 * parse specific server commandos: p1, p2, p3 and p4 are the
			 * players' directions that we receive from our server:
			 */
			else if (msg.startsWith("p3:")) {
				msg = msg.substring(3);
				map.p3dir = msg;
			}
			/**
			 * parse specific server commandos: p1, p2, p3 and p4 are the
			 * players' directions that we receive from our server:
			 */
			else if (msg.startsWith("p4:")) {
				msg = msg.substring(3);
				map.p4dir = msg;
			}
			/**
			 * parse specific server commandos: cha represents the chaos mode
			 **/
			else if (msg.startsWith("cha")) {
				msg = msg.substring(3);
				map.chaos = (msg.equals("true")) ? true : false;
			}
			/**
			 * parse specific server commandos: score represents the current
			 * group-highscore
			 **/
			else if (msg.startsWith("sco")) {
				msg = msg.substring(3);
				map.score = Integer.parseInt(msg);
			}
			/**
			 * parse specific server commandos: psc represents the local
			 * player-score
			 **/
			else if (msg.startsWith("psc")) {
				msg = msg.substring(3);
				mDrawer.localscore = Integer.parseInt(msg);
			}
			/**
			 * let the client know that the game has just been lost
			 */
			else if (msg.equals("end")) {
				lost = true;
				mDrawer.lost = true;
			}
			/**
			 * let the client know that the game was won
			 */
			else if (msg.equals("won")) {
				won = true;
				mDrawer.won = true;
			}
			/**
			 * let the client know that the game has been restarted
			 */
			else if (msg.equals("res")) {
				lost = false;
				mDrawer.lost = false;
			}
			/**
			 * parse specific server commandos: bon represents the bonus
			 **/
			else if (msg.startsWith("bon")) {
				String cooldown = msg.substring(4);
				msg = msg.substring(3, 4);
				map.bonusCooldown = Integer.parseInt(cooldown);
				map.randomBonusNr = Integer.parseInt(msg);
			} else if (msg.startsWith("rf1")) {
				msg = msg.substring(3);
				mDrawer.p1ready = false;
				mDrawer.p1name = msg;
			} else if (msg.startsWith("rt1")) {
				msg = msg.substring(3);
				mDrawer.p1ready = true;
				mDrawer.p1name = msg;
			} else if (msg.startsWith("rf2")) {
				msg = msg.substring(3);
				mDrawer.p2ready = false;
				mDrawer.p2name = msg;
			} else if (msg.startsWith("rt2")) {
				msg = msg.substring(3);
				mDrawer.p2ready = true;
				mDrawer.p2name = msg;
			} else if (msg.startsWith("rf3")) {
				msg = msg.substring(3);
				mDrawer.p3ready = false;
				mDrawer.p3name = msg;
			} else if (msg.startsWith("rt3")) {
				msg = msg.substring(3);
				mDrawer.p3ready = true;
				mDrawer.p3name = msg;
			} else if (msg.startsWith("rf4")) {
				msg = msg.substring(3);
				mDrawer.p4ready = false;
				mDrawer.p4name = msg;
			} else if (msg.startsWith("rt4")) {
				msg = msg.substring(3);
				mDrawer.p4ready = true;
				mDrawer.p4name = msg;
			}
		}
		/** repaint our panel **/
		p.repaint();
	}

	/**
	 * observes if new text is put into the TextInput field
	 * 
	 * @param string
	 *            is a chat-textinput to send out later on
	 */
	@Override
	public void observeTextInput(String string) {
		/** send a chat message to the server -> all clients **/
		serverchan.send(string);
		/** focus our panel after pressing enter **/
		p.setCanvasFocus();
	}

	/**
	 * prints out, which mouse key was pressed
	 */
	@Override
	public void observeMouseClick(MouseEvent mouseEvent) {
		int m = mouseEvent.getButton();
		switch (m) {
		case 1: // left mouse
			/** tells the server, that the client is ready to play a game **/
			if (!ready) {
				serverchan.send("ready");
				ready = !ready;
			} else {
				serverchan.send("unready");
				ready = !ready;
			}
			break;
		case 3: // right mouse
			p.addMessage(" right mouse ");
		default: // if nothing else works - jf debugging
			break;
		}

	}

	/**
	 * prints out which key was pressed if textinput-field was not already in
	 * focus
	 */
	@Override
	public void observeKeyPress(KeyEvent key) {
		/**
		 * send the direction of our arrow-key to our server also add the
		 * pressed arrow direction as debug information to our panel
		 */
		if (key.getKeyCode() == 38) {
			serverchan.send("up");
		} else if (key.getKeyCode() == 40) {
			serverchan.send("down");
		} else if (key.getKeyCode() == 37) {
			serverchan.send("left");
		} else if (key.getKeyCode() == 39) {
			serverchan.send("right");
		}
	}

	/** currently not in use :) **/
	@Override
	public void observeKeyRelease(KeyEvent key) {
	}

};
