package Pacman;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.ImageIcon;

import de.uni_frankfurt.prgpr.phase3.gui.Drawer;

/** extended Drawer class **/
public class MyDrawer implements Drawer {
	/** path to our resources **/
	private String path = System.getProperty("user.dir") + "\\src\\res\\";
	/** Image for Air class **/
	private Image air = new ImageIcon(path + "air.png").getImage();
	/** Image for Pill class **/
	private Image pill = new ImageIcon(path + "pill.png").getImage();
	/** map width **/
	private int xdim;
	/** map height **/
	private int ydim;
	/** map - where the magic happens **/
	private Map map;
	/** score to display on the client **/
	public int localscore;
	/**
	 * true if the game has started, false if not
	 * this will help to switch between main screen and displaying the map
	 **/
	public boolean started = false;
	/** display the dead-pacman logo **/
	public boolean lost = false;
	/** display the won-logo **/
	public boolean won = false;

	/**
	 * name of player 1
	 */
	public String p1name;
	/**
	 * true, if player 1 is ready, false if not
	 */
	public boolean p1ready;
	/**
	 * name of player 2
	 */
	public String p2name;
	/**
	 * true, if player 2 is ready, false if not
	 */
	public boolean p2ready;
	/**
	 * name of player 3
	 */
	public String p3name;
	/**
	 * true, if player 3 is ready, false if not
	 */
	public boolean p3ready;
	/**
	 * name of player 4
	 */
	public String p4name;
	/**
	 * true, if player 4 is ready, false if not
	 */
	public boolean p4ready;

	/** empty constructor **/
	public MyDrawer() {
	}

	/** constructor that takes a map and its dimensions **/
	public MyDrawer(int xdim, int ydim, Map map) {
		this.xdim = xdim;
		this.ydim = ydim;
		this.map = map;
	}

	/** paint the map by parsing our Tile-list **/
	@Override
	public void draw(Graphics g) {
		if (started) {
			/** go through a 2-dimensional array, representing our map: **/
			for (int i = 0; i < xdim; i++) {
				for (int j = 0; j < ydim; j++) {
					/**
					 * check for objects, and paint the images they represent
					 **/
					if (map.getCel(i, j) instanceof Air) {
						g.drawImage(air, i * 16, j * 16, null);
					} else if (map.getCel(i, j) instanceof Wall) {
						g.drawImage(new ImageIcon(path + ((Wall) map.getCel(i, j)).getPlace() + ".png").getImage(),
								i * 16, j * 16, null);
					} else if (map.getCel(i, j) instanceof Pill) {
						if (((Pill) map.getCel(i, j)).power)
							g.drawImage(new ImageIcon(path + "power.png").getImage(), i * 16, j * 16, null);
						else {
							g.drawImage(pill, i * 16, j * 16, null);
						}
					} else if (map.getCel(i, j) instanceof Enemy) {
						if (map.chaos) {
							g.drawImage(new ImageIcon(path + "flee.png").getImage(), i * 16, j * 16, null);
						} else {
							g.drawImage(
									new ImageIcon(path + ((Enemy) map.getCel(i, j)).name
											+ ((Enemy) map.getCel(i, j)).getDir() + ".png").getImage(),
									i * 16, j * 16, null);
						}
					} else if (map.getCel(i, j) instanceof Player) {
						g.drawImage(new ImageIcon(path + ((Player) map.getCel(i, j)).getDir() + ".png").getImage(),
								i * 16, j * 16, null);
					} else if (map.getCel(i, j) instanceof Bonus) {
						if (map.bonusCooldown == 0)
							g.drawImage(new ImageIcon(path + "b" + map.randomBonusNr + ".png").getImage(), i * 16,
									j * 16, null);
						else {
							g.drawImage(air, i * 16, j * 16, null);
						}
					}
				}
				/** show scores on our main canvas : **/
				/** font color **/
				g.setColor(Color.white);
				/** font face and size **/
				g.setFont(new Font("Arial", 0, 20));
				/** display scores **/
				g.drawString("Groupscore: " + map.score, 10, 30);
				g.drawString("Your score: " + localscore, 350, 30);
				if(lost)
					g.drawImage(new ImageIcon(path + "fatality.png").getImage(), 0, 0, null);
				if(won)
					g.drawImage(new ImageIcon(path + "dollars.jpg").getImage(), 225, 141, null);
			}
		} else {
			g.drawImage(new ImageIcon(path + "startscreen800x600.png").getImage(), 0, 0, null);
			try {
				g.setFont(new Font("Arial Black", Font.PLAIN, 25));
				if (p1ready)
					g.setColor(Color.green);
				else {
					g.setColor(Color.red);
				}
				g.drawString(p1name, 210, 380);
				if (p2ready)
					g.setColor(Color.green);
				else {
					g.setColor(Color.red);
				}
				g.drawString(p2name, 210, 410);
				if (p3ready)
					g.setColor(Color.green);
				else {
					g.setColor(Color.red);
				}
				g.drawString(p3name, 440, 380);
				if (p4ready)
					g.setColor(Color.green);
				else {
					g.setColor(Color.red);
				}
				g.drawString(p4name, 440 , 410);
			} catch (Exception e) {
			}
		}
	}
};