package Pacman;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

/**
 * a map represents the maze for pacman including and can be saved as ascii
 * based textfile. And this is how to represent a map as textfile: 'a' := left
 * or right wall 'w' := upper or bottom wall 'q' := upper left corner of a wall
 * 'e' := upper right corner of a wall 'y' := bottom left wall-corner 'c' :=
 * bottom right wall-corner
 * 
 */
public class Map {
	/** width of the map **/
	private int width;
	/** height of the map **/
	private int height;
	/** number of pill that are available for scores **/
	public short pills = 0;
	/** number of players alive on the map **/
	public short players;
	/** can enemies be eaten? **/
	public boolean chaos = false;
	/** is true, if chaos is currently running **/
	public boolean chaosRunning = false;
	/** the time that the choas will last **/
	public int chaosLasting = 0;
	/** determines which random bonus item is to be displayed **/
	public int randomBonusNr = (int) (Math.random() * 4);
	/** the time it takes to respawn the bonus item **/
	public int bonusCooldown = 100;
	/** the direcition of pinky **/
	public String pdir = "right";
	/** the direction of blinky **/
	public String bdir = "right";
	/** the direction of inky **/
	public String idir = "right";
	/** the direction of clyde **/
	public String cdir = "right";
	/** the direction of player 1 **/
	public String p1dir = "right";
	/** the direction of playre 2 **/
	public String p2dir = "right";
	/** the direction of player 3 **/
	public String p3dir = "right";
	/** the direction of player 4 **/
	public String p4dir = "right";
	/** the score that players achieved on the currentmap (sum) **/
	public int score = 0;
	/** default air object **/
	private Air air = new Air();
	/** default pill object **/
	private Pill pill = new Pill(false); // these two are most common on the map
											// and are initialized initially, so
											// we don't need to acutally create
											// 6300 new objects each 170ms
	/** the x coordinate of blinky's spawn **/
	private short blinkyx;
	/** the y coordinate of blinky's spawn **/
	private short blinkyy;
	/** the x coordinate of pinky's spawn **/
	private short pinkyx;
	/** the y coordinate of pinky's spawn **/
	private short pinkyy;
	/** the x coordinate of inky's spawn **/
	private short inkyx;
	/** the y coordinate of inky's spawn **/
	private short inkyy;
	/** the x coordinate of clyde's spawn **/
	private short clydex;
	/** the y coordinate of clyde's spawn **/
	private short clydey;
	/** the x coordinate where to spawn the bonus item **/
	private short bonusx;
	/** the y coordinate where to spawn the bonus item **/
	private short bonusy;
	/** the x coordinate of p1's spawn **/
	private short p1x;
	/** the y coordinate of p1's spawn **/
	private short p1y;
	/** the x coordinate of p2's spawn **/
	private short p2x;
	/** the y coordinate of p2's spawn **/
	private short p2y;
	/** the x coordinate of p3's spawn **/
	private short p3x;
	/** the y coordinate of p3's spawn **/
	private short p3y;
	/** the x coordinate of p4's spawn **/
	private short p4x;
	/** the y coordinate of p4's spawn **/
	private short p4y;

	/** the map represented as two-dimensional char-array **/
	private Tile[][] map;

	/** getter for Tile[][] map **/
	public Tile[][] getTile() {
		return this.map;
	}

	/**
	 * @return the width of the map
	 */
	public int getWidth() {
		return this.width;
	}

	/**
	 * @return the height of the map
	 */
	public int getHeight() {
		return this.height;
	}

	/**
	 * map constructor
	 * 
	 * @param xdim
	 *            is the (int) width of the map
	 * @param ydim
	 *            is the (int) height of the map
	 */
	public Map(int xdim, int ydim) {
		this.width = xdim;
		this.height = ydim;
		this.map = new Tile[xdim][ydim];
	}

	/**
	 * checks the map for pills (pill-counter), row by row, col by col
	 */
	private void setPills() {
		for (int i = 0; i < height; i++) {
			for (int j = 0; j < width; j++) {
				if (this.getCel(j, i) instanceof Pill)
					pills = (short) (((((Pill) this.getCel(j, i)).power)) ? pills : pills + 1);
			}
		}
	}

	/**
	 * getter for number of pills
	 * 
	 * @return the amount of pills as integer
	 */
	public int getPills() {
		return pills;
	}

	/**
	 * setter for pills
	 * 
	 * @param amount
	 *            is the amount of pills as integer
	 */
	public void setPills(int amount) {
		this.pills = (short) amount;
	}

	/**
	 * checks, if there are pills left to increase the player's score
	 * 
	 * @return false if there are pills left and true otherwise
	 */
	public boolean won() {
		// returns false if pills != 0
		return pills == 0;
	}

	/**
	 * checks if the amount of players alive is 0
	 * 
	 * @return true if all players are dead, or, if not, false
	 */
	public boolean lost() {
		return players == 0;
	}

	/**
	 * Takes a Map (Tile) with its parameters for width and length and returns a
	 * String representation used by the server to send the current map over to
	 * all clients
	 * 
	 * @param data
	 *            is the Tile[][] or Map Object
	 * @param width
	 *            is the width of the map
	 * @param height
	 *            is the height of the map
	 * @return a string representation of the map
	 * @see typical implementation is e.g.: Tile[][] t = map.getTile(); String s
	 *      = Map.serialize(t, map.getWidth(), map.getHeight());
	 */
	public static String serialize(Tile[][] data, int width, int height) {
		String map = "";
		for (int j = 0; j < height; j++) { // read the tile matrix by cols
			for (int i = 0; i < width; i++) { // by rows
				if (data[i][j] instanceof Air) { // is the tile at hand an Air
													// object?
					map += " "; // then the String will be extended by " "
				} else if (data[i][j] instanceof Wall) { // current tile is a
															// wall?
					map += ((Wall) (data[i][j])).getPlace(); // get the
																// orientation
																// of it and
																// print it in
																// the string
				} else if (data[i][j] instanceof Pill) { // pill?
					if (((Pill) data[i][j]).power == true) { // is it a
																// power-pill?
						map += "p"; // p marks that a pill is a power pill
					} else {
						map += "-"; // and - marks it as a regular pill
					}

				} else if (data[i][j] instanceof Bonus) { // bonus?
					map += "b"; // here will spawn the bonus item after time
				} else if (data[i][j] instanceof Enemy) { // is it an Enemy?
					String enemyname = ((Enemy) (data[i][j])).name;
					if (enemyname.equals("blinky")) { // blinky is the #1 on our
														// map
						enemyname = "1";
					} else if (enemyname.equals("pinky")) {
						enemyname = "2"; // 2 stands for pinky
					} else if (enemyname.equals("inky")) {
						enemyname = "3"; // 3 is inky
					} else if (enemyname.equals("clyde")) {
						enemyname = "4"; // last, but not least: 4 is clyde
					}
					map += enemyname; // complete our string by finally
										// attaching the right number of Enemy
				} else if (data[i][j] instanceof Player) { // is there a player?
					if (((Player) data[i][j]).alive) {
						if (((Player) data[i][j]).name.equals("p1"))
							map += "5";
						else if (((Player) data[i][j]).name.equals("p2"))
							map += "6";
						else if (((Player) data[i][j]).name.equals("p3"))
							map += "7";
						else if (((Player) data[i][j]).name.equals("p4"))
							map += "8"; // same as for enemies goes for player:
										// get the correct number and
					} else {
						map += " "; // attach it to the string
					}
				}
			}
			map += '\n'; // take care of beginning a new line each 45 (=map
							// width) parsed tiles

		}

		return map; // our build-up string object from the current map is
					// returned.
	}

	/**
	 * deserializes a String Object into a Map Object used by the clients to
	 * extract the current map from the received String
	 * 
	 * @see NEED TO CHECK IMPLEMENTATION OF 1.) intelligence 2.) bonus
	 * @param s
	 *            is the String object
	 * @param w
	 *            map width (NEEDS TO MATCH WITH TRUE WIDTH IN STRING!)
	 * @param h
	 *            map height
	 * @return a Map Object created from String
	 */
	public Map deserialize(String s, int w, int h) {
		String ENEMY_INTELLIGENCE = "intelligent"; // the enemy intelligence is
													// irrelevant for the
													// client. he will soon
													// enough see weather a
													// enemy is chasing him or
													// not ;)
		Scanner sc = new Scanner(s);
		char[] data = new char[width]; // parse the string received from the
										// server
		Map map = new Map(w, h);
		for (int i = 0; sc.hasNextLine(); i++) {
			data = sc.nextLine().toCharArray(); // put the next line in an array
												// to easily handle the
												// information in it
			for (int j = 0; j < data.length; j++) {
				// see class documentation for char translation, pretty much the
				// serialize function reversed
				if (data[j] == ' ')
					map.setCel(j, i, air); // here we use our pre-initialized
											// air object to save resources
				else if (data[j] == 'q' || data[j] == 'w' || data[j] == 'e' || data[j] == 'a' || data[j] == 'y'
						|| data[j] == 'c' || data[j] == '.') // determine the
																// wall
																// orientation
					map.setCel(j, i, new Wall(data[j]));
				else if (data[j] == 'p') {
					map.setCel(j, i, new Pill(true));
				} else if (data[j] == '-')
					map.setCel(j, i, pill);
				else if (data[j] == '1') {
					map.setCel(j, i, new Enemy("blinky", ENEMY_INTELLIGENCE));

				} else if (data[j] == '2') {
					map.setCel(j, i, new Enemy("pinky", ENEMY_INTELLIGENCE));

				} else if (data[j] == '3') {
					map.setCel(j, i, new Enemy("inky", ENEMY_INTELLIGENCE));
				} else if (data[j] == '3') {

				} else if (data[j] == '4') {
					map.setCel(j, i, new Enemy("clyde", ENEMY_INTELLIGENCE)); // intelligence
																				// is
																				// irrelevant
																				// to
																				// the
																				// client,
																				// as
																				// said
				} else if (data[j] == 'b') {
					map.setCel(j, i, new Bonus(0, false));
				} else if (data[j] == '5') {
					map.setCel(j, i, new Player("p1"));
				} else if (data[j] == '6') {
					map.setCel(j, i, new Player("p2"));
				} else if (data[j] == '7') {
					map.setCel(j, i, new Player("p3"));
				} else if (data[j] == '8') {
					map.setCel(j, i, new Player("p4")); // set the players to
														// their current
														// location
				}
			}
		}
		sc.close(); // don't forget to close the scanner
		return map; // return our map object read from the string
	}

	/**
	 * helps the server to load the map from a string file should be removed as
	 * soon as an alternative is found
	 * 
	 * @param file
	 *            the String to read the map from
	 */
	public void loadString(String file) { // will be replaced by loadFile, as
											// soon as we know how to read a
											// .txt file from the server .class
											// location
		Scanner sc = new Scanner(file);
		char[] data = new char[width];
		for (int i = 0; sc.hasNextLine(); i++) {
			data = sc.nextLine().toCharArray();
			for (int j = 0; j < data.length; j++) {
				// see class documentation for char translation
				if (data[j] == ' ')
					map[j][i] = air;
				else if (data[j] == 'q' || data[j] == 'w' || data[j] == 'e' || data[j] == 'a' || data[j] == 'y'
						|| data[j] == 'c' || data[j] == '.')
					map[j][i] = new Wall(data[j]);
				else if (data[j] == 'p') {
					map[j][i] = new Pill(true);
				} else if (data[j] == '-')
					map[j][i] = pill;
				else if (data[j] == '1') {
					map[j][i] = new Enemy("blinky", "random");
					((Enemy) map[j][i]).setDir(bdir);
					blinkyx = (short) j;
					blinkyy = (short) i;
				} else if (data[j] == '2') {
					map[j][i] = new Enemy("pinky", "random");
					((Enemy) map[j][i]).setDir(pdir);
					pinkyx = (short) j;
					pinkyy = (short) i;
				} else if (data[j] == '3') {
					map[j][i] = new Enemy("inky", "random");
					((Enemy) map[j][i]).setDir(idir);
					inkyx = (short) j;
					inkyy = (short) i;
				} else if (data[j] == '4') {
					map[j][i] = new Enemy("clyde", "random");
					((Enemy) map[j][i]).setDir(cdir);
					clydex = (short) j;
					clydey = (short) i;
				} else if (data[j] == 'b') {
					map[j][i] = new Bonus(0, false);
					bonusx = (short) j;
					bonusy = (short) i;
				} else if (data[j] == '5') {
					map[j][i] = new Player("p1");
					((Player) map[j][i]).setDir(p1dir);
					p1x = ((short) j);
					p1y = ((short) i);
				} else if (data[j] == '6') {
					map[j][i] = new Player("p2");
					((Player) map[j][i]).setDir(p2dir);
					p2x = ((short) j);
					p2y = ((short) i);
				} else if (data[j] == '7') {
					map[j][i] = new Player("p3");
					((Player) map[j][i]).setDir(p3dir);
					p3x = ((short) j);
					p3y = ((short) i);
				} else if (data[j] == '8') {
					map[j][i] = new Player("p4");
					((Player) map[j][i]).setDir(p4dir);
					p4x = ((short) j);
					p4y = ((short) i);
				}
			}
		}
		setPills();
		sc.close();

	}

	/**
	 * map-file parser, used for singleplayer
	 * 
	 * @param file
	 *            is a file in ascii format that represents a 2d-map
	 * @throws FileNotFoundException
	 */
	public void loadLevel(File file) throws FileNotFoundException {

		Scanner sc = new Scanner(file);
		char[] data = new char[width]; // works pretty simular to the loadString
										// function

		for (int i = 0; sc.hasNextLine(); i++) {
			data = sc.nextLine().toCharArray();
			for (int j = 0; j < data.length; j++) {
				// see class documentation for char translation
				if (data[j] == ' ')
					map[j][i] = new Air();
				else if (data[j] == 'q' || data[j] == 'w' || data[j] == 'e' || data[j] == 'a' || data[j] == 'y'
						|| data[j] == 'c' || data[j] == '.')
					map[j][i] = new Wall(data[j]);
				else if (data[j] == 'p') {
					map[j][i] = new Pill(true);
				} else if (data[j] == '-')
					map[j][i] = new Pill(false);
				else if (data[j] == '1') {
					blinkyx = (short) j;
					blinkyy = (short) i;
				} else if (data[j] == '2') {
					pinkyx = (short) j;
					pinkyy = (short) i;
				} else if (data[j] == '3') {
					inkyx = (short) j;
					inkyy = (short) i;
				} else if (data[j] == '4') {
					clydex = (short) j;
					clydey = (short) i;
				} else if (data[j] == 'b') {
					map[j][i] = new Bonus(0, false);
					bonusx = (short) j;
					bonusy = (short) i;
				}
			}
		}
		setPills();
		sc.close();
	}

	/**
	 * @return blinky's x coordinates
	 */
	public int getBlinkyX() {
		return blinkyx;
	}

	/**
	 * @return blinky's y coordinates
	 */
	public int getBlinkyY() {
		return blinkyy;
	}

	/**
	 * @return pinky's x coordinates
	 */
	public int getPinkyX() {
		return pinkyx;
	}

	/**
	 * @return pinky's y coordinates
	 */
	public int getPinkyY() {
		return pinkyy;
	}

	/**
	 * @return inky's x coordinates
	 */
	public int getInkyX() {
		return inkyx;
	}

	/**
	 * @return inky's y coordinates
	 */
	public int getInkyY() {
		return inkyy;
	}

	/**
	 * @return clyde's x coordinates
	 */
	public int getClydeX() {
		return clydex;
	}

	/**
	 * @return clyde's y coordinates
	 */
	public int getClydeY() {
		return clydey;
	}

	/**
	 * @param x
	 *            the x pos of the tile to set
	 * @param y
	 *            the y pos of the tile to set
	 * @param tile
	 *            the tile which should be set at given pos(x, y) @ the map
	 */
	public void setCel(int x, int y, Tile tile) {
		map[x][y] = tile;
	}

	/**
	 * @param x
	 *            the x pos of the requested tile
	 * @param y
	 *            the y pos of the requested tile
	 * @return the tile @ map(x, y)
	 */
	public Tile getCel(int x, int y) {
		return map[x][y];
	}

	/**
	 * enables the chaos-mode on the map enemies can now be eaten by players
	 * lasts usually for 25 gamelogic-calculations
	 */
	public void chaosEnable() {
		this.chaos = true;
		this.chaosLasting += 20;
	}

	/**
	 * disables the chaos-mode on the map
	 */
	public void chaosDisable() {
		this.chaos = false;
		this.chaosLasting = 0;
	}

	/**
	 * @return the x position of the bonus item
	 */
	public int getBonusX() {
		return this.bonusx;
	}

	/**
	 * @return the y position of the bonus item
	 */
	public int getBonusY() {
		return this.bonusy;
	}

	/**
	 * @return the x position of p1's spawn
	 */
	public short getP1x() {
		return p1x;
	}

	/**
	 * @return the y position of p1's spawn
	 */
	public short getP1y() {
		return p1y;
	}

	/**
	 * @return the x position of p2's spawn
	 */
	public short getP2x() {
		return p2x;
	}

	/**
	 * @return the y position of p2's spawn
	 */
	public short getP2y() {
		return p2y;
	}

	/**
	 * @return the x position of p3's spawn
	 */
	public short getP3x() {
		return p3x;
	}

	/**
	 * @return the y position of p3's spawn
	 */
	public short getP3y() {
		return p3y;
	}

	/**
	 * @return the x position of p4's spawn
	 */
	public short getP4x() {
		return p4x;
	}

	/**
	 * @return the y position of p4's spawn
	 */
	public short getP4y() {
		return p4y;
	}

	/**
	 * @return the current map as tile[][]
	 */
	public Tile[][] getMap() {
		return map;
	}

	/**
	 * prints the current map in the console, no longer used.
	 */
	public void show() {
		for (int i = 0; i < height; i++) {
			for (int j = 0; j < width; j++) {
				System.out.print(j);
			}
			System.out.println(i);
		}
	}

}
