/*
 * MUSS NICHT GETESTET WERDEN! SINGLEPLAYER ONLY!!!
 */
package Pacman;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;

import javax.swing.ImageIcon;

public class Main {

	public static void main(String[] args) {
		final UIPanel panel = new UIPanel("Pacman");
		/** SinglePlayer :O **/
		final String path = System.getProperty("user.dir") + "res";
		final Player p;
		final Map map;
		final Enemy blinky; // rot
		final Enemy pinky; // pink
		final Enemy inky; // inky
		final Enemy clyde; // orange
		final int xdim = 45;
		final int ydim = 35;
		final AudioHandler audioHandler = new AudioHandler();
		map = new Map(xdim, ydim);
		p = new Player(System.getProperty("user.name"));
		blinky = new Enemy("blinky", "random");
		pinky = new Enemy("pinky", "random");
		inky = new Enemy("inky", "random");
		clyde = new Enemy("clyde", "random");

		/**
		 * EventHandler (keyboard) for PacMan's movement
		 */
		UIEventDelegate em = new UIEventDelegate() {

			@Override
			public void observeTick(int tickCount) {
				if (!map.won() && !map.lost()) {
					audioHandler.setSong(path + "ingame.wav", true);
					p.move();
					if (blinky.alive)
						blinky.move();
					else {
						blinky.deathLasting--;
						if (blinky.deathLasting == 0)
							blinky.spawn(map.getBlinkyX(), map.getBlinkyY(), map);
					}
					if (tickCount > 15) {
						if (pinky.alive)
							pinky.move();
						else {
							pinky.deathLasting--;
							if (pinky.deathLasting == 0)
								pinky.spawn(map.getPinkyX(), map.getPinkyY(), map);
						}
					}
					if (tickCount > 30) {
						if (inky.alive)
							inky.move();
						else {
							inky.deathLasting--;
							if (inky.deathLasting == 0)
								inky.spawn(map.getInkyX(), map.getInkyY(), map);
						}
					}
					if (tickCount > 45) {
						if (clyde.alive)
							clyde.move();
						else {
							clyde.deathLasting--;
							if (clyde.deathLasting == 0)
								clyde.spawn(map.getClydeX(), map.getClydeY(), map);
						}
					}
					if (map.chaos)
						map.chaosLasting--;
					if (map.chaosLasting == 0)
						map.chaosDisable();
					if (map.bonusCooldown > 0)
						map.bonusCooldown--;
					else {
						map.setCel(map.getBonusX(), map.getBonusY(), new Air());
					}
					if (map.getCel(map.getBonusX(), map.getBonusY()) instanceof Air) {
						map.setCel(map.getBonusX(), map.getBonusY(),
								new Bonus(map.randomBonusNr, map.bonusCooldown == 0));
					}
				} else if (map.lost()) {
					audioHandler.setSong(path + "lost.wav", false);
				}
			}

			@Override
			public void observeTextInput(String string) {

			}

			@Override
			public void observeMouseClick(MouseEvent mouseEvent) {

			}

			@Override
			public void observeKeyRelease(KeyEvent key) {

			}

			@Override
			public void observeKeyPress(KeyEvent key) {
				if (key.getKeyCode() == 38 && !map.won() && !map.lost()) {
					if (p.alive) {
						p.isMoving = true;
						p.setDir("up");
					}
				} else if (key.getKeyCode() == 40 && !map.won() && !map.lost()) {
					if (p.alive) {
						p.isMoving = true;
						p.setDir("down");
					}
				} else if (key.getKeyCode() == 37 && !map.won() && !map.lost()) {
					if (p.alive) {
						p.isMoving = true;
						p.setDir("left");
					}
				} else if (key.getKeyCode() == 39 && !map.won() && !map.lost()) {
					if (p.alive) {
						p.isMoving = true;
						p.setDir("right");
					}
				}
			}
		};
		/** draw everything on our canvas **/
		Drawer d = new Drawer() {

			@Override
			public void draw(Graphics g) {
				for (int i = 0; i < xdim; i++) {
					for (int j = 0; j < ydim; j++) {
						if (map.getCel(i, j) instanceof Air) {
							g.drawImage(new ImageIcon(path + "air.png").getImage(), i * 16, j * 16, null);
						} else if (map.getCel(i, j) instanceof Wall) {
							g.drawImage(new ImageIcon(path + ((Wall) map.getCel(i, j)).getPlace() + ".png").getImage(),
									i * 16, j * 16, null);
						} else if (map.getCel(i, j) instanceof Pill) {
							if (((Pill) map.getCel(i, j)).power)
								g.drawImage(new ImageIcon(path + "power.png").getImage(), i * 16, j * 16, null);
							else {
								g.drawImage(new ImageIcon(path + "pill.png").getImage(), i * 16, j * 16, null);
							}
						} else if (map.getCel(i, j) instanceof Enemy) {
							if (map.chaos) {
								g.drawImage(new ImageIcon(path + "flee.png").getImage(), i * 16, j * 16, null);
							} else {
								g.drawImage(
										new ImageIcon(path + ((Enemy) map.getCel(i, j)).name
												+ ((Enemy) map.getCel(i, j)).getDir() + ".png").getImage(),
										i * 16, j * 16, null);
							}
						} else if (map.getCel(i, j) instanceof Player) {
							g.drawImage(new ImageIcon(path + p.getDir() + ".png").getImage(), i * 16, j * 16, null);
						} else if (map.getCel(i, j) instanceof Bonus) {
							if (((Bonus) map.getCel(i, j)).isVisible())
								g.drawImage(new ImageIcon(path + "b"
										+ ((Integer) ((Bonus) map.getCel(i, j)).getNumber()).toString() + ".png")
												.getImage(),
										i * 16, j * 16, null);
							else {
								g.drawImage(new ImageIcon(path + "air.png").getImage(), i * 16, j * 16, null);
							}
						}
					}
					g.setColor(Color.white);
					g.setFont(new Font("Arial", 0, 20));
					g.drawString(p.name + " Score: " + p.getScore(), 10, 30);
				}
			}
		};
		try {
			map.loadLevel(new File(path + "level1.txt"));
		} catch (FileNotFoundException e) {
			System.err.println("Datei nicht gefunden oder fehlerhaft");
			e.printStackTrace();
		}
		p.spawn(13, 18, map);
		blinky.spawn(map.getBlinkyX(), map.getBlinkyY(), map);
		blinky.setIntelligence("looking");
		pinky.spawn(map.getPinkyX(), map.getPinkyY(), map);
		inky.spawn(map.getInkyX(), map.getInkyY(), map);
		clyde.spawn(map.getClydeX(), map.getClydeY(), map);

		panel.setEventDelegate(em);
		panel.setDrawer(d);
		panel.show();
		System.out.println(map.pills);
	}

}
