package Pacman;

/**
 * @author Daniel
 *         implementation of the bonus tile - this will make the player gain
 *         more points
 *         enemies can also take the bonus item, the points gained will be
 *         destroyed
 */
public class Bonus implements Tile {

	/**
	 * 
	 * constructor of the bonus tile
	 * 
	 * @param i
	 *            the index to identify the bonus item. there are 4 possible
	 *            items to be displayed
	 * @param visible
	 *            can the bonus item be seen on canvas and therefore been taken?
	 */
	public Bonus(int i, boolean visible) {
		this.number = i;
		this.setVisible(visible);
	}

	/**
	 * 0 Strawberry, 1 Apple, ...
	 */
	public int number;
	/**
	 * makes the bonus item be seen on map and allow it to be taken by players
	 * and enemies
	 */
	private boolean visible = false;

	/**
	 * @return true if the item is visible, false if not
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * @param visible
	 *            should the item be visible?
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

	/**
	 * @return the index of this instance of bonus. indicates which item should
	 *         be drawn to our canvas
	 */
	public int getNumber() {
		return 1 + number;
	}

}
