package Pacman;

import java.io.File;

import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

/**
 * @author Daniel the audiohandler handles the current song to play this happens
 *         all clientside and loads local .wav files
 */
public class AudioHandler {

	/** name of the current file to play **/
	private String media = "";
	/**
	 * are we currently playing a song? helps to keep the repitition of a song
	 * alive
	 **/
	private boolean playing = false;
	/** the clip file for the inputstream **/
	private Clip clip;
	/** the inputstream for the .wav files to read **/
	private AudioInputStream audioInputStream;

	/**
	 * starts playing a song
	 */
	private void play() {
		if (!playing) // don't open a new stream if there is already one running
			try {
				playing = true;
				audioInputStream = AudioSystem.getAudioInputStream(new File(media));
				clip = AudioSystem.getClip();
				clip.open(audioInputStream);
				clip.start();
			} catch (Exception e) {
			}
	}

	/**
	 * @param media
	 *            the song to play (the file needs to be located @ pacman dir)
	 * @param repeating
	 *            to you wish to repeat the song as soon as it is over?
	 */
	public void setSong(String media, boolean repeating) {
		if (!this.media.equals(media)) { // is a new song to be set?
			this.media = media;
			if (!playing) // prevent opening too many input streams
				play();
			else {
				stop(); // just stop the one currently running in order to swap
						// songs
				play(); // play the new tune ~(^^~)
			}
		}
		if (repeating) // repeats the song as soon as it is over
			repeat();
	}

	/**
	 * takes care of song repitition
	 */
	private void repeat() {
		if (!clip.isActive()) // our current clip is inactive? so the song needs
								// to be over
			stop(); // close the input stream
		play(); // start our song again
	}

	/**
	 * stops the current song and closes its input stream
	 */
	public void stop() {
		try {
			clip.close(); // close the input stream
			playing = false; // so we aren't playing a song anymore
		} catch (Exception e) { // can be called if there isn't an input stream
								// running, so we might catch a nullpointer
								// exception
		} // nobody really wants to handle that boy
	}

}
