package de.uni_frankfurt.prgpr.phase2.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class UserStorage {
	static final String STORAGE_PREFIX = System.getProperty("user.home") + File.separator + "prgpr" + File.separator;

	/**
	 * Stores an object in persistent storage.
	 * 
	 * @param name Name that the object should have in persistent storage (must not contain slashes, backslashes etc.).
	 * The name is not case sensitive.
	 * @param object The Java object to store.
	 * @throws FileNotFoundException Raised if the storage path (prgpr in the user's home directory) isn't set up.
	 * @throws IOException Any input/output errors that occurred.
	 */
	public void store(String name, Serializable object) throws FileNotFoundException, IOException {
		name = name.toLowerCase();
		ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(STORAGE_PREFIX + name + ".store"));
		os.writeObject(object);
		os.close();
	}
	
	/**
	 * Loads an object from persistent storage.
	 * 
	 * @param name Name of the persistent storage slot to load from (case-insensitive).
	 * @return The Java object retrieved from there, or <tt>null</tt>.
	 */
	public Object load(String name) {
		try {
			name = name.toLowerCase();
			ObjectInputStream istream = new ObjectInputStream(new FileInputStream(STORAGE_PREFIX + name + ".store"));
			Object obj = istream.readObject();
			istream.close();
			return obj;
		} catch (Exception _) {
			return null;
		}
	}
}
