package de.uni_frankfurt.prgpr.phase2.sprites;

import static org.junit.Assert.*;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;

import org.junit.Test;

import de.uni_frankfurt.prgpr.core.ClientRunner;
import de.uni_frankfurt.prgpr.core.MockClient;
import de.uni_frankfurt.prgpr.core.MockMain;
import de.uni_frankfurt.prgpr.core.MockServer;
import de.uni_frankfurt.prgpr.phase2.gui.Gradient;

/**
 * 
 * Testklasse für Phase 2
 *
 */
public class TestSuite {

	String path = System.getProperty("user.home");
	Spritesheet ssh = null;
	SpritesheetLoader sl = null;

	/**
	 * Testet, ob die Intensität größer 255 sein kann
	 * 
	 * @throws IOException
	 *             falls die Intensität zu groß ist
	 */

	@Test(expected = RuntimeException.class)
	public void testGradientIntensityTooLarge() {
		Color tmp = Gradient.getColor(Color.WHITE, Color.WHITE, 420); // 420 >
																		// 255
																		// ->
																		// Crash
		tmp.getRed();
	}

	/**
	 * Testet, ob sich eine Farbe nach Belieben einfärben lässt und ob die
	 * Intensität korrekt verarbeitet wird. Der Alpha Kanal wird hierbei
	 * ignoriert.
	 */
	@Test
	public void testGradient() {

		Color tmp = new Color(0, 0, 0, 0); // schwarz
		tmp = Gradient.getColor(tmp, Color.RED, 0);
		assertTrue(tmp.getBlue() == 0 && tmp.getGreen() == 0 && tmp.getRed() == 0); // immernoch
																					// schwarz,
																					// da
																					// Intensität
																					// =
																					// 0
		tmp = Gradient.getColor(tmp, Color.CYAN, 50);
		assertTrue(tmp.getRed() == 0 && tmp.getGreen() > 0 && tmp.getBlue() > 0); // blau
																					// und
																					// grün
																					// wurden
																					// erhöht,
																					// entspricht
																					// einem
																					// dunkel-cyan-Ton
		tmp = Gradient.getColor(tmp, Color.RED, 255);
		assertTrue(tmp.getRed() == 255 && tmp.getGreen() == tmp.getBlue() && tmp.getBlue() == 0); // Farbe
																									// ist
																									// komplett
																									// rot,
																									// da
																									// Intensität
																									// =
																									// 255
																									// =
																									// max
	}

	/**
	 * Testet, ob Spritesheets geladen werden können
	 * 
	 * @throws IOException
	 *             falls das Laden fehlschlägt
	 */

	@Test
	public void testLoad() throws IOException {

		sl = SpritesheetLoader.defaultLoader();
		ssh = sl.getSpritesheet("graphics/sprites/model/Talponian_male");
		ssh.getCel(0);
	}

	/**
	 * Testet, ob das Einfärben eines bestimmten Kanals funktioniert
	 * 
	 * @throws IOException
	 *             falls das Laden fehlschlägt
	 */
	@Test
	public void testDye() throws IOException {
		testLoad();
		BufferedImage before = (BufferedImage) ssh.getImage();
		int white = before.getRGB(40, 40);
		int red = before.getRGB(32, 40);
		Color col = new Color(white);
		assertTrue(col.getRed() == col.getBlue() && col.getGreen() == col.getBlue()); // Bildpunkt
																						// ist
																						// im
																						// weissen
																						// DyeChannel
		ssh.dye(Color.RED, 200, "WHITE");
		Color col2 = new Color(red);
		assertTrue(col2.getBlue() == 0 && col2.getRed() > 100 && col2.getGreen() == 0); // Bildpunkt
																						// ist
																						// im
																						// roten
																						// DyeChannel
		ssh.dye(Color.GREEN, 255, "RED");
		BufferedImage after = (BufferedImage) ssh.getImage();
		int whiteAfter = after.getRGB(40, 40);
		int redAfter = after.getRGB(32, 40);
		col = new Color(whiteAfter);
		col2 = new Color(redAfter);
		assertTrue(col.getRed() > 100); // Bildpunkt wurde rötlich gefärbt
		assertTrue(col.getGreen() < 100); // Das Grünfärben des roten
											// DyeChannels beeinträchtigt nicht
											// den weissen DyeChannel
		assertTrue(col2.getGreen() > 100); // Bildpunkt wurde grün gefärbt.
	}

	@Test
	public void testAllDyeChannels() throws IOException {

		sl = SpritesheetLoader.defaultLoader();
		ssh = sl.getSpritesheet("graphics/sprites/equipment/override/child-outfits");
		ssh.dye(Color.WHITE, 120, "MAGENTA");
		ssh.dye(Color.RED, 120, "BLUE");
		ssh.dye(Color.BLUE, 120, "CYAN");
		ssh.dye(Color.BLACK, 120, "YELLOW");
		ssh.dye(Color.MAGENTA, 120, "GREEN");
	}

	/**
	 * Testet das Gesamtkonstrukt, bestehend aus dem erstellen des IUPanels, mit
	 * dem Server verbinden. Es werden keine RuntimeExceptions erwartet. Test
	 * verläuft positiv, wenn es keine Exceptions gibt.
	 */
	@Test
	public void testMain() {
		ClientRunner.main(null);
	}

	/**
	 * Testet die funktionalität des MockServers- und Clients. Der Server
	 * speichert alle verbundenen Clients und logt die erhaltenen Nachrichten.
	 */
	@Test
	public void testMock() {

		MockClient user = new MockClient("user");
		assertEquals("user", user.getName());
		MockServer server = new MockServer();
		server.connect(user);
		server.receive(user, "ku$h");
		assertEquals("ku$h", server.getLastEntry());
		MockMain.main(null);
	}

	/**
	 * Testet ob der erzeugte Farbverlauf Farben innerhalb der gewünschten
	 * Toleranz liefert
	 */
	@Test
	public void testDrawGradient() {
		BufferedImage gr = Gradient.draw(Color.RED, Color.WHITE);
		// erzeuge Farbverlauf
		assertEquals(gr.getRGB(0, 0), Color.RED.getRGB());
		// ganz links ist die erste Farbe?
		assertTrue(((gr.getRGB(254, 0)) & 0xFF) > Color.WHITE.getRed() - 5);
		// angenommen, die Farbe darf maximal um 5 abweichen dann muss ganz
		// rechts etwa die zweite Farbe sein
		assertTrue(((gr.getRGB((254 / 2), 0)) & 0xFF) > (Color.WHITE.getRed() - 5) / 2);
		// und bei der Hälfte ist die Hälfte der zweiten Farbe vertreten ->
		// Gradient verhält sich wie gewünscht
	}

}
