package de.uni_frankfurt.prgpr.phase2.sprites;

/**
 * Spritesheets can be dyed, using colours indicated by DyeChannels.  There are seven DyeChannels,
 * which each describe a set of pixels.  Recall that each pixel is made up of values (red, green, blue),
 * and optionally a fourth `alpha' value (which we ignore here).
 * 
 * The DyeChannel RED describes all pixels whose green and blue RGB values are zero.
 * The DyeChannel YELLOW describes all pixels whose blue values are zero while at the same
 * time their red and green values are equal. 
 * 
 * @author creichen
 *
 */
public enum DyeChannel {
	RED(true, false, false),
	GREEN(false, true, false),
	BLUE(false, false, true),
	CYAN(false, true, true),
	MAGENTA(true, false, true),
	YELLOW(true, true, false),
	WHITE(true, true, true);
	
	
	boolean r, g, b; // colour must be equal for everything listed as `true', and zero for everything else
	
	/**
	 * Constructs a new DyeChannel
	 * @param red
	 * @param green
	 * @param blue
	 */
	DyeChannel(boolean red, boolean green, boolean blue) {
		this.r = red;
		this.g = green;
		this.b = blue;
	}
	
	public boolean hasRed() {
		return this.r;
	}
	public boolean hasGreen() {
		return this.g;
	}
	public boolean hasBlue() {
		return this.b;
	}
}
