package de.uni_frankfurt.prgpr.phase2.sprites;

public enum Direction {
	UP(0, -1),
	DOWN(0, 1),
	LEFT(-1, 0),
	RIGHT(1, 0),
	DEFAULT(0, 0);
	
	private int dx;
	private int dy;

	/**
	 * Creates a direction
	 * 
	 * @param dx X vector for the direction (is it pointing right (1) or left (-1)?)
	 * @param dy Y vector for the direction (is it pointing up (-1) or down (1)?) 
	 */
	Direction(int dx, int dy) {
		this.dx = dx;
		this.dy = dy;
	}
	
	/**
	 * Where on the X axis is this direction facing?
	 * 
	 * @return -1, 0, or 1
	 */
	public int getXDirection() {
		return this.dx;
	}
	
	/**
	 * Where on the Y axis is this direction facing?
	 * 
	 * @return -1, 0, or 1
	 */
	public int getYDirection() {
		return this.dy;
	}
}
