package de.uni_frankfurt.prgpr.phase2.sprites;

import de.uni_frankfurt.prgpr.phase2.gui.UIPanel;

/**
 * Represents the animation state in a given animation
 * 
 * @author creichen
 *
 */
public class AnimationState {
	/**
	 * 
	 */
	private final Animation animation;

	int sequencePos = 0;
	boolean finished = false;
	public static int current = 0;
	public static int currentTick = 0;

	/**
	 * Constructs a fresh animation state
	 * 
	 * @param animation
	 *            TODO
	 */
	public AnimationState(Animation animation) {
		this.animation = animation;
		reset();
	}

	public Animation getAnimation() {
		return this.animation;
	}

	/**
	 * Retrieves the current cel sequence
	 * 
	 * @return The current cel sequence
	 */
	public CelSequence seq() {
		return this.animation.getCelSequence(0 /** may need fixing with multiple* cel sequences*/);
	}

	/**
	 * Resets the animation state to the first index
	 */
	public void reset() {
		sequencePos = seq().getStart();
	}

	/**
	 * Determines the horizontal (x) offset that the cel should be drawn to
	 * relative to the base coordinates
	 * 
	 * @return The horizontal offset
	 */
	public int getXOffset() {
		return seq().getXOffset();
	}

	/**
	 * Determines the vertical (y) offset that the cel should be drawn to
	 * relative to the base coordinates
	 * 
	 * @return The vertical offset
	 */
	public int getYOffset() {
		return seq().getYOffset();
	}

	/**
	 * Determines the amount of time that should elapse before the next
	 * animation step
	 * 
	 * @return Amount of time to elapse, in milliseconds
	 */
	public int getDelay() {
		return this.animation.getCelSequence(0 /* FIXME, perhaps? */)
				.getDelay();
	}

	/**
	 * Gets the index of the cel that should be drawn for the current state of
	 * the animation
	 * 
	 * @return The cel index
	 */
	public int getCel() {
		if (isFinished()) {
			return -1;
		}
//		 return seq().getDelay();
//		System.out.println("CURRENT: " + current);
//		int currentCel = (this.animation.getCelSequence(current).getStart()) + sequencePos;
		return sequencePos;
	}

	/**
	 * Advances the animation by one step
	 * 
	 * @return false if the animation is finished and there are no more steps
	 */
	public boolean next() {
		
		if (finished) {
			if(animation.isLooping()){ // loop
				finished = false;
				sequencePos = seq().getStart();
				return true;
			}
			return false;
		}
		
		if(getDelay() < currentTick){ 
			currentTick = 0;
			
			if(sequencePos < seq().getEnd()){
				sequencePos++;
				return true;
			}else{
				finished = true;
			}
		}
		
		currentTick += UIPanel.TICKER_DELAY;
		return true;
		
	}

	/**
	 * Determines whether the animation is finished
	 * 
	 * @return true iff the animation has been completed
	 */
	public boolean isFinished() {
		return this.finished;
	}
	
}