package de.uni_frankfurt.prgpr.phase2.gui;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class Gradient {

	static Color start;
	static Color end;
	static int differenceR;
	static int differenceG;
	static int differenceB;

	/**
	 * @param start
	 *            erste Zahl (ist hier der Rotwert der Startfarbe)
	 * @param end
	 *            zweite Zahl (Rotwert der Zielfarbe)
	 * @param point
	 *            Punkt anschaulich die Intensität zwischen erster- und zweiter
	 *            Zahl
	 * @return die Zahl, die realtiv zum Abstand von der ersten zur zweiten Zahl
	 *         auf dem Abstand zwischen der ersten und zweiten Zahl liegt.
	 */
	public static int getRed(int start, int end, int point) {
		float finalRed = 1;
		float percentageRed = (float) point / 255; // skaliere Point
		float lengthRed = (differenceR * percentageRed); // ermittle die zu
															// "gehende" Strecke
		if (start > end)
			finalRed = start - lengthRed; // muss die finalred verringert oder
											// erhöht werden?
		else
			finalRed = lengthRed + start;
		return ((int) finalRed); // gebe den neuen Farbwert zurück
	}

	/**
	 * @param start
	 *            erste Zahl (ist hier der Rotwert der Startfarbe)
	 * @param end
	 *            zweite Zahl (Rotwert der Zielfarbe)
	 * @param point
	 *            Punkt anschaulich die Intensität zwischen erster- und zweiter
	 *            Zahl
	 * @return die Zahl, die realtiv zum Abstand von der ersten zur zweiten Zahl
	 *         auf dem Abstand zwischen der ersten und zweiten Zahl liegt.
	 */
	public static int getGreen(int start, int end, int point) {
		float finalGreen = 1;
		float percentageGreen = (float) point / 255;
		float lengthGreen = (differenceG * percentageGreen);
		if (start > end)
			finalGreen = start - lengthGreen;
		else
			finalGreen = lengthGreen + start;
		return ((int) finalGreen);
	}

	/**
	 * @param start
	 *            erste Zahl (ist hier der Rotwert der Startfarbe)
	 * @param end
	 *            zweite Zahl (Rotwert der Zielfarbe)
	 * @param point
	 *            Punkt anschaulich die Intensität zwischen erster- und zweiter
	 *            Zahl
	 * @return die Zahl, die realtiv zum Abstand von der ersten zur zweiten Zahl
	 *         auf dem Abstand zwischen der ersten und zweiten Zahl liegt.
	 */
	public static int getBlue(int start, int end, int point) {
		float finalBlue = 1;
		float percentageBlue = (float) point / 255;
		float lengthBlue = (differenceB * percentageBlue);
		if (start > end)
			finalBlue = start - lengthBlue;
		else
			finalBlue = lengthBlue + start;
		return ((int) finalBlue);
	}

	/**
	 * @param c1
	 *            erste Farbe, von der aus zu einer weiteren Farbe gradiert
	 *            werden soll
	 * @param c2
	 *            zweite Farbe, Ziel des Gradienten
	 * @param point
	 *            Punkt, oder bildlich die Intensität zwischen den beiden
	 *            Punkten
	 * @return die Farbe an der Stelle point auf dem Gradienten zwischen c1 und
	 *         c2
	 */
	public static Color getColor(Color c1, Color c2, int point) {
		if (point < 256) {
			start = c1;
			end = c2;
			differenceR = Math.abs((start.getRed() - end.getRed())); // wie weit
																		// liegen
																		// die
																		// Rotwerte
																		// auseinander?
			differenceG = Math.abs((start.getGreen() - end.getGreen())); // und
																			// grün?
			differenceB = Math.abs((start.getBlue() - end.getBlue())); // und
																		// blau?
			return (new Color(getRed(c1.getRed(), c2.getRed(), point), getGreen(c1.getGreen(), c2.getGreen(), point),
					getBlue(c1.getBlue(), c2.getBlue(), point), 255));

		} else {
			throw new RuntimeException("Intensität darf nicht größer 255 sein!");
		}
	}

	/**
	 * @param c1
	 *            Farbe 1, von der der Gradient ausgeht
	 * @param c2
	 *            Farbe 2, zu der der Gradient gradieren soll
	 * @return BufferedImage, das den Gradienten grafisch darstellt diese
	 *         MEthode diente lediglich zu Vergewissern, dass die Methode
	 *         getColor die erwarteten Ergebnisse liefert
	 */
	public static BufferedImage draw(Color c1, Color c2) {
		BufferedImage bf = new BufferedImage(256, 1, BufferedImage.TYPE_INT_ARGB);
		for (int i = 0; i < 255; i++) {
			bf.setRGB(i, 0, getColor(c1, c2, i).getRGB());
		}
		return bf;
	}

}