package de.uni_frankfurt.prgpr.core;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;


/**
 * A class that sends a project update to a bppr server
 * 
 * @author creichen
 *
 */
public class UpdateClient {
	/**
	 * @return
	 * @throws IOException
	 */
	static byte[] loadJarFile() throws IOException {
		//System.err.println("seeking in " + FileSystems.getDefault().getPath(".", Config.JAR_FILENAME).toAbsolutePath());
//		return Files.readAllBytes(FileSystems.getDefault().getPath(Config.JAR_FILENAME));
		String userDirectiory =  System.getProperty("user.dir");
		String finalPath = (userDirectiory.concat("\\")).concat(Config.JAR_FILENAME);
		System.out.println("Path: " + finalPath);
		try { // load jar
			System.out.println("Loading Jar-File");
			return Files.readAllBytes(FileSystems.getDefault().getPath(finalPath));
		} catch (Exception e) {
			System.out.println("Error loading Jar-File");
			System.out.println("Error: " + e.toString());
			System.out.println("Path: "+ FileSystems.getDefault().getPath(Config.JAR_FILENAME));
		}
		System.out.println("returning null");
		return null;
	}
	
	/**
	 * Main entry point; starts up the client and prepares and sends an update message
	 * @param args
	 * @throws IOException
	 */
	public static final void main(String[] args) throws IOException {
		Message.Update message = new Message.Update();
		message.setClientMainClass(Config.CLIENT_CLASS.getName());
		message.setServerMainClass(Config.SERVER_CLASS.getName());
		message.setProject(Config.PROJECT_NAME);
		message.setVersion(Config.PROJECT_VERSION);
		message.setJarData(loadJarFile());
		
		Client client = new Client(Config.SERVER_NAME);
		Message reply = client.sendMessage(message);
		System.out.println("reply: " +reply);
	}
}