package de.uni_frankfurt.prgpr.core;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

/**
 * Interface that observes UI events as reports from a UIPanel
 * 
 * @author creichen
 *
 */
public interface UIEventDelegate {
	/**
	 * Called periodically to indicate that a `tick' of game time has passed.
	 * 
	 * Will be called every tick, unless the system is under very high load.
	 * Tick length is fixed in UIPanel (usually 25 ms).
	 * 
	 * @param tickCount Total number of ticks since the first invocation of this method
	 */
	void observeTick(int tickCount);

	/**
	 * Called whenever the UIPanel observes a key press.
	 * 
	 * May report multiple key press events if a key is held.
	 * This will not report key presses that are reported directly to the input panel.
	 * 
	 * @param key The key that was pressed.
	 */
	void observeKeyPress(KeyEvent key);
	
	/**
	 * Called whenever the UIPanel observes a key release.
	 * 
	 * @param key The key that was released.
	 */
	void observeKeyRelease(KeyEvent key);

	/**
	 * Observes a mouse click.
	 * 
	 * @param mouseEvent An event that describes the click (coordinates and button pressed)
	 */
	void observeMouseClick(MouseEvent mouseEvent);

	/**
	 * Observes string input from the input panel.
	 * 
	 * @param string The input string.
	 */
	void observeTextInput(String string);
}
