package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;
import java.util.ArrayList;

public class MyServer implements ServerInterface{

	ArrayList<ChannelInterface> myClients = new ArrayList<ChannelInterface>();
	LogInterface l;
	String tmp = "before init\n";
	Serializable reply = null;
	
	@Override
	public void init(LogInterface logInterface) {
		logInterface.println("init");
		this.l = logInterface;
	}

	@Override
	public void update(int ticks) {
		l.println(tmp);
		// check if disconnected
		for(int i = 0; i < myClients.size(); i++){
			
			ChannelInterface ci = myClients.get(i);
			if (reply == null) {		//Lausche nach ankommenden Nachrichten
				reply = ci.receiveNext();
			} else {
//				System.out.println("received message: " + reply.toString());
				receive(ci, reply);
//				tmp += reply.toString();
				reply = null;
			}
			
			if(ci.isDisconnected()){
//				l.println("Client " +ci.toString()+ " disconnected");
				tmp += ("Client " +ci.toString()+ " disconnected\n");
				
				ci.disconnect();
				myClients.remove(i);
			}
			
			
		}
	}

	@Override
	public boolean connectClient(ChannelInterface client) {
		//check if client already available
		try {
			myClients.add(client);
			tmp += "Client " +client.toString() + " connected\n";
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	@Override
	public void receive(ChannelInterface client, Serializable message) {
		tmp += message.toString()+"\n";
		for(ChannelInterface c : myClients){
//			l.println(message.toString());
//			tmp += message.toString();
//			dont let client who sends, send again
			if(c != client){
				c.send(message);
			}
		}
	}
}
