package de.uni_frankfurt.prgpr.core;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;

import de.uni_frankfurt.prgpr.phase2.gui.UIPanel;
import de.uni_frankfurt.prgpr.phase2.sprites.Entity;
import de.uni_frankfurt.prgpr.phase2.sprites.Spritesheet;
import de.uni_frankfurt.prgpr.phase2.sprites.SpritesheetLoader;

public class MyListener implements UIEventDelegate {

	ChannelInterface ci = null;
	UIPanel myPanel = null;
	Serializable reply = null;
	boolean enabaledChat = false;	//ist false, so lange noch kein Username eingegeben wurde
	String name = "default";		//name des Nutzers im Chat

	@Override
	public void observeTick(int tickCount) {
		if (reply == null) {		//Lausche nach ankommenden Nachrichten
			reply = ci.receiveNext();
		} else {
//			System.out.println("received message: " + reply.toString());
			
			myPanel.addMessage(reply.toString());	//angekommene Nachricht wird ins Panel geschrieben
			reply = null;
		}
	}

	@Override
	public void observeKeyPress(KeyEvent key) {
		if (key.getKeyCode() == 65)		//WASD, zum Steuern des Avatars
			Entity.setDir("left");
		if (key.getKeyCode() == 68)
			Entity.setDir("right");
		if (key.getKeyCode() == 83)
			Entity.setDir("down");
		if (key.getKeyCode() == 87)
			Entity.setDir("up");
//		System.out.println("key: " + key.toString() + " has been pressed");
	}

	@Override
	public void observeKeyRelease(KeyEvent key) {
		Entity.setDir("none");		//sorgt dafür, dass der Avatar stehen bleibt
	}

	@Override
	public void observeMouseClick(MouseEvent mouseEvent) {
		if (mouseEvent.getY() < 500) {
			myPanel.setCanvasFocus();		//Klick fiel auf das Canvas, ermöglicht Steuerung des Avatars
		} else
			myPanel.setInputFieldFocus();	//Fokus auf das Inputfield, ermöglicht Chatten
//		System.out.println("mouse: " + mouseEvent.toString() + " has been clicked");

	}

	public void custom(){
		String path = "graphics/sprites/model/oversized";
		try {
			SpritesheetLoader ssl = SpritesheetLoader.defaultLoader();
			Spritesheet sh = ssl.getSpritesheet(path);
			Entity.setSpritesheet(0, sh);
		} catch (IOException e) {
			System.out.println("something went wrong");
			e.printStackTrace();
		}
	}
	
	@Override
	public void observeTextInput(String input) {
		if (!enabaledChat) {	//erstmal den Namen eingeben
			name = input;
			enabaledChat = true;	//ab nun darf gechattet werden
		} else {
			System.out.println("input: " +input);
			if(input.equals("test")){
				//TODO: call event
				custom();
				
				
				
				System.out.println("call event");
			}
			myPanel.addMessage(name + ":\t" + input + "\n"); // eigene
																// Nachricht
																// anzeigen
			ci.send(name + ":\t" + input + "\n");	//setze eigene Nachricht in den Chat
		}

	}

	public void setChannel(ChannelInterface ci) {
		this.ci = ci;
	}

	public void setPanel(UIPanel myPanel) {
		this.myPanel = myPanel;
	}

	public void gettingUserName() {
		enabaledChat = false;
	}

	public String getName() {
		return this.name;
	}
}