package de.uni_frankfurt.prgpr.core;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import de.uni_frankfurt.prgpr.phase2.gui.UIPanel;

import de.uni_frankfurt.prgpr.phase2.gui.Drawer;
import de.uni_frankfurt.prgpr.phase2.sprites.AnimationState;
import de.uni_frankfurt.prgpr.phase2.sprites.Direction;
import de.uni_frankfurt.prgpr.phase2.sprites.Entity;
import de.uni_frankfurt.prgpr.phase2.sprites.Spritesheet;

public class MyDrawer implements Drawer {

	private int x = 0;
	private int y = 0;

	void wait(int ms) {
		try {
			Thread.sleep(ms);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void draw(Graphics g) {

		long pos = 0;		//diese Variable wird verwendet um durch die Zellen zu laufen
		ArrayList<Spritesheet> myList = Entity.getArrayList();
		AnimationState as;		//wir haben nur das Laufen animiert
		Image im = null;
		for (int i = 0; i < myList.size(); i++) {		//durchlaufe alle gezeichneten Spritesheets
			if (Entity.getDir() == "down") {		//laufe "runter"
				as = myList.get(i).startAction("walk", Direction.DOWN);
				y++;		//lokale Position wird gemäß der Bewegung verändert
			} else if (Entity.getDir() == "up") {		//ebenso für die anderen Richtungen
				as = myList.get(i).startAction("walk", Direction.UP);
				y--;
			} else if (Entity.getDir() == "left") {
				as = myList.get(i).startAction("walk", Direction.LEFT);
				x--;
			} else if (Entity.getDir() == "right") {
				as = myList.get(i).startAction("walk", Direction.RIGHT);
				x++;
			} else {
				as = myList.get(0).startAction("walk", Direction.DEFAULT);
			}

			if (!(Entity.getDir() == "none"))	//bewegt sich der Avatar, nutzen wir die Variable pos um durch die Zellen zu iterieren
				pos = ((UIPanel.tick) % (as.seq().getEnd() - as.seq().getStart()) + as.seq().getStart());
			else
				pos = 0;	//Avatar steht? pos bleibt auf Zelle 0

//			 die Laufanimation ist 6 Zellen lang
			//			for (int j = 0; j < 61; j++) {

				BufferedImage help = new BufferedImage(64, 64, BufferedImage.TYPE_INT_ARGB);	//64x64 sind die Maße des Standardavatars
				help = (BufferedImage) myList.get(i).getCel((int) pos);		//hole die aktuelle Zelle
				Graphics2D rg = help.createGraphics();		//speichere sie
				rg.drawImage(help, 0, 0, null);		
				im = (Image) help;
				g.drawImage(im, x, y, null);
		}
	}
}
