package de.uni_frankfurt.prgpr.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class InMemoryJarClassLoader extends ClassLoader {
	private byte[] data;
	
	private Map<String, byte[]> classes = new HashMap<String, byte[]>(); 

	public InMemoryJarClassLoader(ClassLoader parent, byte[] data) {
		super(parent);
		this.data = data;
		init();
	}
	
	public void init() {
		System.err.println("Initialising classloader...");
		try {
			try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.data))) {
				for (JarEntry je = jis.getNextJarEntry(); je != null; je = jis.getNextJarEntry()) {
					String name = je.getName();
					final int classOffset = name.indexOf(".class");
					if (classOffset < 0) {
						// manifest file or other data resource
						continue;
					}
					final String className = name.substring(0, classOffset).replaceAll("/","\\.");
					final int bytesPerBlock = 1024;
					byte data[] = new byte[bytesPerBlock];
					int bytesRead, totalBytesRead = 0;
					while ((bytesRead = jis.read(data, totalBytesRead, bytesPerBlock)) > -1) {
						totalBytesRead += bytesRead;
						byte[] newData = new byte[totalBytesRead + bytesPerBlock];
						System.arraycopy(data, 0, newData, 0, totalBytesRead);
						data = newData;
					}
					byte[] classData = new byte[totalBytesRead];
					System.arraycopy(data, 0, classData, 0, totalBytesRead);
					classes.put(className, classData);
				}
			}
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	
	public byte[] getData() {
		return this.data;
	}
	
	@Override
	public Class<?> findClass(String name) throws ClassNotFoundException {
		byte[] b = classes.get(name);
		if (b == null) {
			return super.findClass(name);
		}
		return defineClass(name, b, 0, b.length);
	}
}
