package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Trivial server implementation to illustrate ServerInterface.
 * @author creichen
 */
public class EchoServer implements ServerInterface {

	public static LogInterface l = null;
	ArrayList<ChannelInterface> list = new ArrayList<ChannelInterface>();
	public String tmp = "default1\n";
	public boolean initSuccessful = false;

	/**
	 * Alias for l.println(String s);
	 */
	public void say(String s) {
		if (initSuccessful) l.println(s);
		else return;
	}
	
	
	/**
	 * Called when the server is first initialised
	 * @param log
	 *            A logging system that can be used for output
	 */
	@Override
	public void init(LogInterface log) {
		l = log;
		initSuccessful = true;
		say("init");
	}

	/**
	 * Called regularly, ideally once every `tick' (25 ms)
	 * This method may not be called for every tick. It's possible to determine
	 * skipped ticks by looking at the `ticks' parameter.
	 * @param ticks
	 *            The number of ticks elapsed since the server started
	 */
	@Override
	public void update(int ticks) {
		say(tmp);
	}

	public void printClients(){
	}
	/**
	 * Called when the server observes a client connection
	 * 
	 * @param client
	 *            The client that wants to connect
	 * @return true iff the connection was accepted
	 */
	@Override
	public boolean connectClient(ChannelInterface client) {
		list.add(client);
		return true;
	}

	/**
	 * Called when the server receives a message
	 * @param client
	 *            The client who sent the message
	 * @param message
	 *            The object that is the message
	 */
	@Override
	public void receive(ChannelInterface client, Serializable message) {
		tmp += (String)message;
		for(ChannelInterface ci : list) ci.send(message);
	}
}