package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;


/**
 * Trivial server implementation to illustrate ServerInterface.
 * @author creichen
 *
 */
public class DummyServer implements ServerInterface {
	/**
	 * Called when the server is first initialised
	 * 
	 * @param log A logging system that can be used for output
	 */
	@Override
	public void init(LogInterface log) {
		log.println("1337");
		System.out.println("test1");
		log.println("test1");
	}

	/**
	 * Called regularly, ideally once every `tick' (25 ms)
	 * 
	 * This method may not be called for every tick.  It's possible to determine
	 * skipped ticks by looking at the `ticks' parameter.
	 * 
	 * @param ticks The number of ticks elapsed since the server started
	 */
	@Override
	public void update(int ticks) {
		
	}

	/**
	 * Called when the server observes a client connection
	 * 
	 * @param client The client that wants to connect
	 * @return true iff the connection was accepted
	 */
	@Override
	public boolean connectClient(ChannelInterface client) {
		return false;
	}

	/**
	 * Called when the server receives a message
	 * 
	 * @param client The client who sent the message
	 * @param message The object that is the message
	 */
	@Override
	public void receive(ChannelInterface client, Serializable message) {
	}
}