package de.uni_frankfurt.prgpr.core;

import java.io.File;


public interface Config {
	/**
	 * Deployment server IP address or name
	 */
	public static final String SERVER_NAME = "phylla.rbi.cs.uni-frankfurt.de";
	/**
	 * Deployment server port number
	 */
	public static final int SERVER_PORT = 50705;
	/**
	 * Name of your project to update
	 */
	public static final String PROJECT_NAME = "DanielW+MateuszJ";
	/**
	 * Project version to update (must increase on every update!)
	 */
	public static final int PROJECT_VERSION = 1;
	/**
	 * Name of the main class that the SERVER should use.
	 */
	//public static final Class<? extends ServerInterface> SERVER_CLASS = DummyServer.class;
	public static final Class<? extends ServerInterface> SERVER_CLASS = MyServer.class;
	/**
	 * Name of the main class that the CLIENT should use.
	 */
	public static final Class<? extends ClientInterface> CLIENT_CLASS = MyClient.class;
	/**
	 * Name of the jar file containing the server and client code
	 */
	public static final String JAR_FILENAME = "prg.jar";
	
	//DEBUG
	public static final String GRAPHICS_PATH = System.getProperty("user.home")
			+ File.separator + "prgpr" + File.separator + "graphics.zip";
}
