package de.uni_frankfurt.prgpr.core;

import java.awt.Color;
import java.io.IOException;

import de.uni_frankfurt.prgpr.phase2.gui.UIPanel;
import de.uni_frankfurt.prgpr.phase2.sprites.Entity;
import de.uni_frankfurt.prgpr.phase2.sprites.Spritesheet;
import de.uni_frankfurt.prgpr.phase2.sprites.SpritesheetLoader;

/**
 * Generic system for requesting and executing client code
 * 
 * @author creichen
 *
 */
public class ClientRunner {
	private Client communicationsClient;
	byte[] clientJar; // Client jar file, if we have one
	private String mainClassName;
	private String projectName;
	
	/**
	 * Constructs a new ClientRunner that connects to a particular server
	 * 
	 * @param serverName The server to connect to
	 */
	public ClientRunner(String serverName) {
		communicationsClient = new Client(serverName);
	}
	
	/**
	 * Loads the client data jar files for a given project from the given server
	 * 
	 * @param projectName Name of the project to load
	 * @return true iff the load was successful
	 */
	public boolean loadClient(String projectName) {
		try {
			this.projectName = projectName;
			Message request = new Message.GetClient();
			request.setProject(projectName);
			Message reply = communicationsClient.sendMessage(request);
			if (reply instanceof Message.Client) {
				Message.Client cd = (Message.Client) reply;
				clientJar = cd.getJarData();
				mainClassName = cd.getClientMainClass();
			}
			return true;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * Runs a previously loaded client
	 */
	public void run(UIPanel panel) {
		if (clientJar == null || mainClassName == null) {
			throw new RuntimeException("No client code available to run!  Make sure to run loadClient() first.");
		}
		InMemoryJarClassLoader classloader = new InMemoryJarClassLoader(this.getClass().getClassLoader(), clientJar);
		try {
			ChannelInterface serverChannel = communicationsClient.connect(projectName);
			Class<?> c = classloader.findClass(mainClassName);
			Object obj = c.newInstance();
			ClientInterface client = (ClientInterface) obj;
			client.init(panel, serverChannel);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new RuntimeException(t);
		}
	}
	
	public static SpritesheetLoader initMySpritesheetLoader(){
		SpritesheetLoader ssl = null;
		try {
			ssl = SpritesheetLoader.defaultLoader();
			System.out.println("SpritesheetLoader: " + ssl.toString());
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return ssl;
	}
	
	public static Spritesheet initMySpritesheet(SpritesheetLoader ssl, String path){
		Spritesheet ss = null;
		try {
			ss = ssl.getSpritesheet(path);
			System.out.println("Spritesheet: "+ss.toString()); 
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return ss;
	}
	
	/**
	 * Main method, runs a client selected by name
	 * 
	 * @param args
	 */
	public static final void main(String[] args) {
		// Clients
		System.out.println("BEFORE ENTITY1");
		ClientRunner cl = new ClientRunner(Config.SERVER_NAME);
		cl.loadClient(Config.PROJECT_NAME);
		UIPanel myPanel = new UIPanel("test");
		cl.run(myPanel);
		
		System.out.println("BEFORE ENTITY2");
		// Sprites
		SpritesheetLoader myLoader = initMySpritesheetLoader();
		String finalPath = "graphics/sprites/model/Talponian_female";
		String pathPullover = "graphics/sprites/equipment/chest/tnecksweater-female";
		String pathBoots = "graphics/sprites/equipment/feet/boots-female";
		String pathPants = "graphics/sprites/equipment/legs/pants-female";
		System.out.println("path: " +finalPath);
		
		
		Spritesheet test = initMySpritesheet(myLoader, finalPath);
		Spritesheet pullover = initMySpritesheet(myLoader, pathPullover);
		Spritesheet boots = initMySpritesheet(myLoader, pathBoots);
		Spritesheet pants = initMySpritesheet(myLoader, pathPants);
		boots.dye(Color.BLACK, 200, "WHITE");
		pullover.dye(new Color(50, 200, 50), 130, "WHITE");
		pants.dye(Color.RED, 120, "WHITE");
		Entity e = new Entity("test", 10, 10, test, pullover, boots, pants);
//		Entity e = new Entity("test", 10, 10, test);
		
		
		
//		System.out.println("SIZE: " +e.getArrayList().size());
//		System.out.println("NAME: " +e.getArrayList().get(0).toString());
		MyDrawer myDrawer = new MyDrawer();
		myPanel.setDrawer(myDrawer);
		Entity.setDir("none");
		e.getX();
		
		
		System.out.println("main done");
	}
}
