package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;

/**
 * A two-way communications channel, used to communicate server-to-client or client-to-server.
 * 
 * Messages are guaranteed to be delivered in-order.
 * 
 * @author creichen
 *
 */
public interface ChannelInterface {
	/**
	 * Sends a message over the channel.
	 * 
	 * @param obj The object to send.
	 */
	public void send(Serializable obj);

	/**
	 * Receives the next message from this communications channel
	 * 
	 * @return The next message, or <tt>null</tt> if there is none yet
	 */
	public Serializable receiveNext();

	/**
	 * Tests whether the connection has been closed.
	 * 
	 * @return true iff the connection is closed.
	 */
	boolean isDisconnected();

	/**
	 * Closes communications and disconects
	 */
	void disconnect();
}
