package de.uni_frankfurt.prgpr.phase1.aufgabe9;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * Testklasse fuer Aufgabe 9
 * 
 */
public class TestSuite {
	/*--------------------------------------------------------------------
	 AUFGABENSTELLUNG
	
	Schreiben Sie Basisklassen fuer die Simulation eines Tiergeheges, und
	testen sie diese mit Modultests.  Teil der Simulation ist, die
	Position und Geschwindigkeit der Tiere und deren Essverhalten
	zu beschreiben.
	
	Simulieren Sie folgende Tiere:
	- Elephant (frisst "grass")
	- Mouse (frisst "cheese")
	- Squirrel (frisst "nuts")
	
	Jedes dieser Tiere soll dabei in eine eigene Klasse.
		
	(1) Jede der drei Tierklassen soll einen Konstruktor haben, der die
	    Geschwindigkeit des Tieres als Parameter nimmt.
	(2) Jede Klasse hat eine Methode `likesFood(String)', die einen boolean-
	    Wert zurueckliefert.  Dieser ist true gdw das Tier das per
	    Zeichenkette angegebene Nahrungsmittel frisst (siehe Angaben
	    oben).
	(3) Jede Klasse hat Methoden `setSpeed(int)' und `int getSpeed()',
	    die die Geschwindigkeit des Tiers setzen bzw. auslesen.
	(4) Jede Klasse hat eine Methode `setCoords(int x, int y)', die die
	    x- und y-Koordinate des Tieres setzen.
	(5) Methoden `getX()' und `getY()' liefern die x- und y-Koordinate
	    des Tieres.  Anfangs sind die Koordinaten auf 100, 100.
	(6) Jede Klasse hat eine Methode `walkTowards(int x, int y)'.  Diese
	    Methode verschiebt die Position des Tieres von der aktuellen
	    Position in Richtung (x, y), aber nur soweit, wie von der
	    Geschwindigkeit erlaubt.  Dabei sollen sich x und y so aendern,
	    als ob das Tier tatsaechlich auf die gegebene Position zusteuert.
	    Beispiel:
	       Tier auf (100,100), Geschwindigkeit 10, walkTowards(10, 10)
	       => Tier ist nun auf (95, 95).
	       Tier auf (20, 20).  Geschwindigkeit 15, walkTowards(40, 30).
	       => Tier ist nun auf (30, 25).
	    Natuerlich darf das Tier nicht ueber das Ziel hinausschiessen.
	(7) Wenn die Koordinaten auf einer Achse kleiner als 0 werden, sollen
	    sie automatisch auf 0 gesetzt werden, denn dort ist im simulierten
	    Gehege ein Zaun angebracht. 
	
	
	
	TIP #1: UEberlegen Sie, ob ihre Tiere gemeinsame Funktionalitaet haben--
	Sie koennen sich viel Tipparbeit sparen, wenn Sie gemeinsame
	Funktionalitaet in Klassen oder Methoden abstrahieren.
	
	TIP #2: Achten Sie darauf, nicht versehentlich durch 0 zu dividieren!
	
	Implementieren Sie alle JUnit-Tests in der Klasse TestSuite im
	gleichen Paket.
	---------------------------------------------------------------------*/

	/**
	 * Testmethode um zu zeigen, dass die Tiere ihr Essen am meisten mögen ^_^
	 */

	@Test
	public void testFood() {
		Squirrel s = new Squirrel(50);
		assertTrue(s.likesFood("nuts"));
		assertFalse(s.likesFood("Döner"));
		Elephant e = new Elephant(2);
		assertTrue(e.likesFood("grass"));
		assertFalse(e.likesFood("Pflastersteine"));
		Mouse m = new Mouse(30);
		assertTrue(m.likesFood("cheese"));
		assertFalse(m.likesFood("Alte Socken"));
	}

	/**
	 * Testmethode um zu zeigen, dass eine Instanz eines Objektes der Klasse
	 * Elephant, Squirrel und Mouse die Standard-Koordinaten x=100 und y=100 hat
	 */

	@Test
	public void testCoords() {
		Squirrel s = new Squirrel(30);
		assertEquals(100, s.getX());
		assertEquals(100, s.getY());
	}

	/**
	 * Testmethode um zu zeigen, dass man per setCoords(x, y) die Koordinaten
	 * setzen kann
	 */

	@Test
	public void testSetCoords() {
		Squirrel s = new Squirrel(40);
		s.setCoords(30, 500);
		assertEquals(30, s.getX());
		assertEquals(500, s.getY());
	}

	/**
	 * Testmethode um zu testen, ob sich die walkTowards-Methode korrekt verhält
	 * mit legaler Eingabe
	 */

	@Test
	public void testWalk() {
		Elephant e = new Elephant(10);
		e.walkTowards(90, 90);
		assertEquals(95, e.getX());
		assertEquals(95, e.getX());
		Mouse m = new Mouse(15);
		m.setCoords(20, 20);
		assertEquals(20, m.getX());
		assertEquals(20, m.getY());
		m.walkTowards(40, 30);
		assertEquals(30, m.getX());
		assertEquals(25, m.getY());
	}

	/**
	 * Testmethode um zu zeigen, dass negative Werte nicht zulässig sind.
	 */

	@Test(expected = RuntimeException.class)
	public void testWalkFail() {
		Elephant e = new Elephant(20);
		e.walkTowards(-43, 3);
	}

	/**
	 * Testmethode, um zu zeigen, dass man nicht unter x=0 und y=0 laufen kann
	 * (Zaun laut Aufgabe)
	 */

	@Test
	public void gehege() {
		Elephant e = new Elephant(1337);
		e.walkTowards(0, 0);
		assertEquals(0, e.getX());
		assertEquals(0, e.getY());
	}
}
