package de.uni_frankfurt.prgpr.phase1.aufgabe9;

/**
 * @author Daniel<br>
 * 
 *         Klasse Mouse, kann sich auf x- und y- Achsen frei bewegen, mag Käse
 */
public class Mouse {

	private String food = "cheese"; // hier wird das Lieblingsessen festgelegt
	private int x = 100; // Wert der x-Koordinate
	private int y = 100; // Wert der y-Koordinate
	private int speed; // Wert für die Geschwindigkeit des Tieres

	/**
	 * @param a
	 *            wird dem Konstruktor übergeben, um der Instanz des Objektes
	 *            einen Wert für speed zuzuweisen
	 * @throws RuntimeException
	 *             falls <b>a</b> nicht größer Null ist!
	 */

	public Mouse(int a) {
		if (a > 0)
			speed = a; // Konstruktor, der speed auf den erhaltenen Wert setzt
		else
			throw new RuntimeException("Der Wert für speed muss größer Null sein!");
	}

	/**
	 * @param a
	 * @return true, falls <b>a</b> mit dem Lieblingsessen überineinstimmt,<br>
	 *         false sonst.
	 */
	public boolean likesFood(String a) {
		return (a.equals(food)) ? true : false;
	}

	/**
	 * @param a<br>
	 *            setzt speed auf <b>a</b>
	 */
	public void setSpeed(int a) {
		speed = a;
	}

	/**
	 * @return speed
	 */
	public int getSpeed() {
		return speed;
	}

	/**
	 * @param x
	 *            setzt den x-Wert des Objektes auf <b>x</b>
	 * @param y
	 *            setzt den y-Wert des Objektes auf <b>y</b>
	 */
	public void setCoords(int x, int y) {
		this.x = x;
		this.y = y;
	}

	/**
	 * @return x-Koordinate des Objektes
	 */
	public int getX() {
		return x;
	}

	/**
	 * @return y-Koordinate des Objektes
	 */
	public int getY() {
		return y;
	}

	/**
	 * @param a
	 *            int
	 * @param b
	 *            int
	 * @return den Abstand zwischen <b>a</b> und <b>b</b>
	 */
	private int dist(int a, int b) {
		return Math.abs(a - b);
	}

	/**
	 * @param tx
	 *            "to x" - ist Ziel auf der x-Achse für das Objekt
	 * @param ty
	 *            "to y" - ist Ziel auf der y-Achse für das Objekt <br>
	 *            Berechnet die Relation zwischen der zurückzulegenden x- und
	 *            y-Strecke, und bewegt das Objekt <b>speed</b> oft in diese
	 *            Richtung. Es wird verhindert, über das Ziel hinauszuschiessen.
	 * @throws RuntimeException
	 *             bei negativer Eingabe
	 */
	public void walkTowards(int tx, int ty) {
		if (ty < 0 || tx < 0)
			throw new RuntimeException("Negative Werte sind nicht zulässig");
		int streckeX = dist(x, tx); // absolute Distanz auf der x-Achse
									// zurückzulegen
		int streckeY = dist(y, ty); // absolute Distanz auf der y-Achse
									// zurückzulegen
		int gesamtStrecke = streckeX + streckeY; // errechne Gesamtstrecke
		double relX = (gesamtStrecke == 0) ? 1 : (double) streckeX / gesamtStrecke; // errechne
																					// den
																					// relativen
																					// Anteil
																					// der
																					// x-Strecke
																					// an
																					// der
																					// Gesamtstrecke,
																					// sollten
																					// wir
																					// durch
																					// Null
																					// teilen
																					// müssen,
																					// ist
																					// die
																					// Realtion
																					// immer
																					// 1
		double relY = (gesamtStrecke == 0) ? 1 : (double) streckeY / gesamtStrecke; // errechne
																					// den
																					// relativen
																					// Anteil
																					// der
																					// y-Strecke
																					// an
																					// der
																					// Gesamtstrecke
		if (x < tx) { // müssen wir von der Null weg?
			if (x + speed * relX >= tx)
				x = tx; // schiessen wir über das Ziel hinaus?
			else
				x += speed * relX; // ansonsten, laufe Richtung Ziel auf der
									// x-Achse
		} else if (x > tx) { // müssen wir Richtung Null laufen?
			if (x - speed * relX <= tx)
				x = tx; // schiessen wir über das Ziel hinaus?
			else
				x -= speed * relX; // ansonsten, laufe Richtung Ziel auf der
									// x-Achse
		}
		if (y < ty) { // müssen wir von der Null weg?
			if (y + speed * relY >= ty)
				y = ty; // schiessen wir über das Ziel hinaus?
			else
				y += speed * relY; // ansonten, laufe Richtung Ziel auf der
									// y-Achse
		} else if (y > ty) { // müssen wir Richtung Null gehen?
			if (y - speed * relY <= ty)
				y = ty; // schiessen wir über das Ziel hinaus?
			else
				y -= speed * relY; // ansonsten, laufe Richtung Ziel auf der
									// y-Achse
		}
	}

}
