package de.uni_frankfurt.prgpr.phase1.aufgabe7;

/**
 * IntAccount repräsentiert ein Bankkonto, in dem die gespeicherten Beträge als
 * Ganzzahlen (int) abgelegt werden.
 *
 */
public class IntAccount extends GenericAccount {

	private int balance;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe7.Account#deposit(int)
	 */
	public void deposit(int i) {
		if (i >= 0)
			balance += i;
		else
			throw new RuntimeException("Man kann kein negatives Geld einzahlen.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe7.Account#withdraw(int)
	 */
	public void withdraw(int i) {
		if (i >= 0) {
			if (balance - i >= 0) {
				balance -= i;
			} else
				throw new RuntimeException("Kontostand zu niedrig");
		} else
			throw new RuntimeException("Man kann kein negatives Geld abheben");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe7.Account#getBalance()
	 */
	public int getBalance() {
		return balance;
	}

	/**
	 * Konstruktor der Klasse ohne Argumente. <b>balance</b> wird auf 0 gesetzt.
	 */
	public IntAccount() {
		balance = 0;
	}

	/**
	 * @param n
	 *            ist der Wert, mit dem <b> balance </b> initialisiert wird.
	 */
	public IntAccount(int n) {
		balance = n;
	}

}
