package de.uni_frankfurt.prgpr.phase1.aufgabe7;

import java.math.BigInteger;

/**
 * IntAccount repräsentiert ein Bankkonto, in dem die gespeicherten Beträge als
 * Ganzzahlen (int) abgelegt werden.
 *
 */
/**
 * @author Daniel
 *
 */
public class BigIntAccount extends GenericAccount {

	public java.math.BigInteger balance;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe7.Account#deposit(int)
	 */
	public void deposit(int i) {
		if (i > 0)
			balance = balance.add(BigInteger.valueOf(i));
		else
			throw new RuntimeException("Der eingezahlte Betrag muss größer 0 sein.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe7.Account#withdraw(int)
	 */
	public void withdraw(int i) {

		if (i > 0) {

			if ((balance.subtract(BigInteger.valueOf(i)).compareTo(BigInteger.valueOf(0)) >= 0)) {
				balance = balance.subtract(BigInteger.valueOf(i));
			}

			else {
				throw new RuntimeException("Kontostand zu niedrig");
			}

		} else
			throw new RuntimeException("Der abgehobene Betrag muss größer 0 sein.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe7.Account#getBalance()
	 */
	public int getBalance() {
		if (balance.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0)
			return Integer.MAX_VALUE;
		else
			return balance.intValueExact();
	}

	/**
	 * Konstruktor der Klasse. <b> balance </b> wird mit 0 initialisiert.
	 */
	public BigIntAccount() {
		balance = BigInteger.valueOf(0);
	}

	/**
	 * @param n
	 *            ist der Wert, mit dem <b> balance </b> initialisiert wird.
	 */
	public BigIntAccount(int n) {
		balance = BigInteger.valueOf(n);
	}

}
