package de.uni_frankfurt.prgpr.phase1.aufgabe6;

import static org.junit.Assert.*;

import org.junit.Test;

import de.uni_frankfurt.prgpr.phase1.aufgabe4.IntAccount;
import de.uni_frankfurt.prgpr.phase1.aufgabe5.BigIntAccount;

/**
 * Testklasse für Aufgabe 6
 *
 * Prüft das Verhalten der statischen Methode Transfer.transfer
 */
public class TestSuite {

	/**
	 * Testmethode um zu zeigen, dass die transfer-Methode Geld wie erwartet von
	 * einem Konto auf ein anderes schiebt.
	 */
	@Test
	public void test1() {
		Account a1 = new IntAccount();
		Account a2 = new BigIntAccount();
		a1.deposit(50);
		Transfer.transfer(a1, a2, 50);
		assertEquals(50, a2.getBalance());
	}

	/**
	 * Testmethode um zu zeigen, dass man auch von einem BigIntAccount auf einen
	 * IntAccount überweisen kann. Alles verläuft nach Erwartung.
	 */
	@Test
	public void krempel() {
		int s = 1500000000; // 2s > 2147483647
		Account a = new IntAccount();
		Account b = new BigIntAccount();
		b.deposit(s);
		b.deposit(s);
		assertEquals(Integer.MAX_VALUE, b.getBalance());
		b.withdraw(s);
		Transfer.transfer(b, a, s);
		a.withdraw(s);
		assertEquals(0, a.getBalance());
	}

}
