package de.uni_frankfurt.prgpr.phase1.aufgabe5;

import static org.junit.Assert.*;

import org.junit.Test;

//import de.uni_frankfurt.prgpr.phase1.aufgabe4.IntAccount;

/**
 * 
 * Testklasse für Aufgabe 5
 *
 */
public class TestSuite {
	
	/**
	 * Testmethode zum Erzeugen eines leeren Kontos und zum Einzahlen von Geld
	 */

	@Test
	public void testInsert() {
		BigIntAccount i1 = new BigIntAccount();
		assertEquals(0, i1.getBalance());
		i1.deposit(1500000000);
		i1.deposit(1500000000);
		assertEquals(Integer.MAX_VALUE, i1.getBalance());
	}

	/**
	 * Testmethode zum Erzeugen eines Kontos mit vordefiniertem Kontostand
	 */

	@Test
	public void testInsert2() {
		BigIntAccount i1 = new BigIntAccount(30);
		assertEquals(30, i1.getBalance());
	}
	
	/**
	 * Testmethode zum Zeigen, dass man kein negatives Geld einzahlen kann
	 */
	@Test(expected = RuntimeException.class)
	public void testNegativeDeposit(){
		BigIntAccount i1 = new BigIntAccount();
		i1.deposit(-420);
	}
	
	/**
	 * Testmethode zum Zeigen, dass man kein negatives Geld abheben kann
	 */
	@Test(expected = RuntimeException.class)
	public void testNegativeWithdraw(){
		BigIntAccount i1 = new BigIntAccount();
		i1.withdraw(-420);
	}


	/**
	 * Testmethode um zu zeigen, dass man von einem leeren Konto kein Geld
	 * abheben kann
	 */
	
	@Test(expected = RuntimeException.class)
	public void testWithdraw() {
		BigIntAccount i1 = new BigIntAccount();
		i1.withdraw(1);
	}

	/**
	 * Testmethode um zu zeigen, dass man von einem Konto kein Geld abheben
	 * kann, wenn dort nicht ausreichend liegt
	 */
	
	@Test(expected = RuntimeException.class)
	public void testWithdrawTooMuch() {
		BigIntAccount i1 = new BigIntAccount();
		i1.deposit(1337);
		i1.withdraw(1338);
	}

	/**
	 * Testmethode um ein Konto zu befüllen und zu leeren
	 */
	
	@Test
	public void testKonto() {
		BigIntAccount i1 = new BigIntAccount();
		i1.deposit(30);
		assertEquals(30, i1.getBalance());
		//i1.withdraw(30);
		//assertEquals(0, i1.getBalance());
	}

	/**
	 * Testmethode um zu zeigen, dass i2 ebenfalls betroffen ist
	 */
	
	@Test
	public void testDoppelteKonten(){
		BigIntAccount i1 = new BigIntAccount();
		BigIntAccount i2 = i1;
		i1.deposit(40);
		assertEquals(40, i2.getBalance());	
	}
	
	/**
	 * Testmethode, um zu zeigen, dass der Int gesprengt werden kann
	 */
	
	@Test
	public void testTooBigInt(){
		BigIntAccount i1 = new BigIntAccount();
		i1.deposit(1500000000);
		i1.deposit(1500000000);
		assertTrue(i1.getBalance() > 0); //hier knallt's nicht mehr :)
	}

}
