package de.uni_frankfurt.prgpr.phase1.aufgabe5;

import java.math.BigInteger;

import de.uni_frankfurt.prgpr.phase1.aufgabe6.Account;

/**
 * IntAccount repräsentiert ein Bankkonto, in dem die gespeicherten Beträge als
 * Ganzzahlen (int) abgelegt werden.
 *
 */
public class BigIntAccount implements Account {

	public java.math.BigInteger balance;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe6.Account#deposit(int)
	 */
	public void deposit(int i) {
		if (i > 0)
			balance = balance.add(BigInteger.valueOf(i));
		else
			throw new RuntimeException("Der eingezahlte Betrag muss größer 0 sein.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe6.Account#withdraw(int)
	 */
	public void withdraw(int i) {

		if (i > 0) {

			if ((balance.subtract(BigInteger.valueOf(i)).compareTo(BigInteger.valueOf(0)) >= 0)) {
				balance = balance.subtract(BigInteger.valueOf(i));
			}

			else {
				throw new RuntimeException("Kontostand zu niedrig");
			}

		} else
			throw new RuntimeException("Der abgehobene Betrag muss größer 0 sein.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe6.Account#getBalance()
	 */
	public int getBalance() {
		if (balance.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0)
			return Integer.MAX_VALUE;
		else
			return balance.intValueExact();
	}

	/**
	 * Konstruktor der Klasse. Wird kein Parameter übergeben, wird
	 * <b>balance</b> mit 0 initialisiert.
	 */
	public BigIntAccount() {
		balance = BigInteger.valueOf(0);
	}

	/**
	 * @param n
	 *            ist der Betrag, der anfangs auf dem Konto sein soll.<br>
	 *            Wird <b>n</b> übergeben, wird <b>balance</b> auf <b> n</b>
	 *            gesetzt.
	 */
	public BigIntAccount(int n) {
		balance = BigInteger.valueOf(n);
	}

	public static void main(String[] args) {

	}

}
