package de.uni_frankfurt.prgpr.phase1.aufgabe4;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * 
 * Testklasse für Aufgabe 4
 *
 */
public class TestSuite {

	/**
	 * Testmethode zum Erzeugen eines leeren Kontos und zum Einzahlen von Geld
	 */

	@Test
	public void testInsert() {
		IntAccount i1 = new IntAccount();
		assertEquals(0, i1.getBalance());
		i1.deposit(4000);
		assertEquals(4000, i1.getBalance());
	}

	/**
	 * Testmethode zum Erzeugen eines Kontos mit vordefiniertem Kontostand
	 */

	@Test
	public void testInsert2() {
		IntAccount i1 = new IntAccount(30);
		assertEquals(30, i1.getBalance());
	}

	/**
	 * Testmethode um zu zeigen, dass man von einem leeren Konto kein Geld
	 * abheben kann
	 */
	@Test(expected = RuntimeException.class)
	public void testWithdraw() {
		IntAccount i1 = new IntAccount();
		i1.withdraw(1);
	}

	/**
	 * Testmethode um zu zeigen, dass man von einem Konto kein Geld abheben
	 * kann, wenn dort nicht ausreichend liegt
	 */
	@Test(expected = RuntimeException.class)
	public void testWithdrawTooMuch() {
		IntAccount i1 = new IntAccount();
		i1.deposit(1337);
		i1.withdraw(1338);
	}

	/**
	 * Testmethode zum Zeigen, dass man kein negatives Geld einzahlen kann
	 */
	@Test(expected = RuntimeException.class)
	public void testNegativeDeposit() {
		IntAccount i1 = new IntAccount();
		i1.deposit(-420);
	}

	/**
	 * Testmethode zum Zeigen, dass man kein negatives Geld abheben kann
	 */
	@Test(expected = RuntimeException.class)
	public void testNegativeWithdraw() {
		IntAccount i1 = new IntAccount();
		i1.withdraw(-420);
	}

	/**
	 * Testmethode um ein Konto zu befüllen und zu leeren
	 */
	@Test
	public void testKonto() {
		IntAccount i1 = new IntAccount();
		i1.deposit(30);
		assertEquals(30, i1.getBalance());
		i1.withdraw(30);
		assertEquals(0, i1.getBalance());
	}

	/**
	 * Testmethode um zu zeigen, dass i2 ebenfalls betroffen ist
	 */
	@Test
	public void testDoppelteKonten() {
		IntAccount i1 = new IntAccount();
		IntAccount i2 = i1;
		i1.deposit(1337);
		assertEquals(1337, i2.getBalance());
	}

	/**
	 * Testmethode, um zu zeigen, dass der Int gesprengt werden kann
	 */
	@Test
	public void testTooBigInt() {
		IntAccount i1 = new IntAccount();
		i1.deposit(1500000000);
		i1.deposit(1500000000);
		assertFalse(i1.getBalance() > 0); // hier knallt's :)
											// assertTrue lässt den Test nicht
											// erfolgreich durchlaufen, aber ich
											// mag den roten Balken in der JUnit
											// nicht :P
	}

}
