package de.uni_frankfurt.prgpr.phase1.aufgabe4;

import de.uni_frankfurt.prgpr.phase1.aufgabe6.Account;

/**
 * IntAccount repräsentiert ein Bankkonto, in dem die gespeicherten Beträge als
 * Ganzzahlen (int) abgelegt werden.
 * 
 * @author Daniel
 */
public class IntAccount implements Account {

	private int balance;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe6.Account#deposit(int)
	 */
	public void deposit(int i) {
		if (i >= 0)
			balance += i;
		else
			throw new RuntimeException("Man kann kein negatives Geld einzahlen.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe6.Account#withdraw(int)
	 */
	public void withdraw(int i) {
		if (i >= 0) {
			if (balance - i >= 0) {
				balance -= i;
			} else
				throw new RuntimeException("Kontostand zu niedrig");
		} else
			throw new RuntimeException("Man kann kein negatives Geld abheben");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.uni_frankfurt.prgpr.phase1.aufgabe6.Account#getBalance()
	 */
	public int getBalance() {
		return balance;
	}

	/**
	 * Konstruktor der Klasse. Wird kein Parameter übergeben, wird
	 * <b>balance</b> mit 0 initialisiert
	 */
	public IntAccount() {
		balance = 0;
	}

	/**
	 * @param n
	 *            ist der Betrag, der anfangs auf dem Konto sein soll.<br>
	 *            <b>balance</b> wird auf <b>n</b> gesetzt, sollte ein Int
	 *            übergeben werden.
	 */
	public IntAccount(int n) {
		balance = n;
	}

}
